/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.catmvnplugin;

import com.github.mike10004.catmvnplugin.Guava;
import com.github.mike10004.catmvnplugin.OrderableFileSet;
import com.github.mike10004.catmvnplugin.OrderableFileSetManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="cat", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
@NotThreadSafe
public class ConcatenateMojo
extends AbstractMojo {
    @Parameter
    private OrderableFileSet[] sources;
    @Parameter
    private File outputFile;
    @Parameter
    private boolean ignoreEmptySourcesList;
    @Parameter(defaultValue="repeat")
    private RepeatedFileStrategy repeatedFileStrategy = RepeatedFileStrategy.repeat;
    @Parameter
    private String divider = "";
    private static final String DEFAULT_DIVIDER_CHARSET = "${project.build.sourceEncoding}";
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String dividerCharset;

    private static String describeFileset(@Nullable FileSet fileset) {
        if (fileset == null) {
            return "null";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("directory", fileset.getDirectory());
        map.put("includes", fileset.getIncludes());
        map.put("excludes", fileset.getExcludes());
        return "FileSet{" + ((Object)map).toString() + "}";
    }

    protected Collection<File> createBucket() {
        return this.repeatedFileStrategy.createBucket();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.sources == null) {
            throw new IllegalStateException("sources filesets not yet set");
        }
        Collection<File> sourceFiles = this.createBucket();
        OrderableFileSetManager fileSetManager = new OrderableFileSetManager();
        this.getLog().debug((CharSequence)(this.sources.length + " sources specified"));
        for (int i = 0; i < this.sources.length; ++i) {
            OrderableFileSet fileset = this.sources[i];
            String filesetDir = fileset.getDirectory();
            if (filesetDir == null) {
                throw new MojoExecutionException("fileset directory not set on fileset at index " + i + ": " + ConcatenateMojo.describeFileset(fileset));
            }
            File parent = new File(filesetDir);
            String[] includedFiles = fileSetManager.getIncludedFiles(fileset);
            if (!fileset.isIgnoreEmptyIncludedFilesList() && includedFiles.length == 0) {
                throw new NoYieldFromFileSetException(fileset, i);
            }
            Stream.of(includedFiles).forEach(p -> {
                File file = new File(parent, (String)p);
                boolean result = sourceFiles.add(file);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("included file " + file + " (Collection.add = " + result + ")"));
                }
            });
        }
        if (!this.ignoreEmptySourcesList && sourceFiles.isEmpty()) {
            throw new NoYieldFromAnyFilesetsException();
        }
        try {
            this.writeConcatenated(sourceFiles);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to copy source files to destination " + this.outputFile, (Exception)e);
        }
    }

    protected Charset getDividerCharset() {
        Charset charset;
        if (Guava.Strings.isNullOrEmpty(this.dividerCharset) || DEFAULT_DIVIDER_CHARSET.equals(this.dividerCharset)) {
            charset = Charset.defaultCharset();
            if (!Guava.Strings.isNullOrEmpty(this.divider)) {
                this.getLog().warn((CharSequence)("using default charset for divider: " + charset.name() + "; set project.build.sourceEncoding property in pom or explicitly set <dividerCharset> parameter"));
            }
        } else {
            charset = Charset.forName(this.dividerCharset.toUpperCase());
        }
        return charset;
    }

    protected void writeConcatenated(Iterable<File> sourceFiles) throws IOException {
        byte[] dividerBytes = Guava.Strings.nullToEmpty(this.divider).getBytes(this.getDividerCharset());
        if (this.outputFile == null) {
            throw new IllegalStateException("output file not set");
        }
        Guava.Files.createParentDirs(this.outputFile);
        int numFiles = 0;
        try (FileOutputStream output = new FileOutputStream(this.outputFile);){
            for (File sourceFile : sourceFiles) {
                if (numFiles > 0 && dividerBytes.length > 0) {
                    ((OutputStream)output).write(dividerBytes);
                }
                try (FileInputStream input = new FileInputStream(sourceFile);){
                    Guava.ByteStreams.copy(input, output);
                }
                ++numFiles;
            }
        }
        this.getLog().info((CharSequence)String.format("concatenated %d file(s) to %s%s%s", numFiles, StringUtils.abbreviateMiddle((String)this.outputFile.getParent(), (String)"...", (int)64), File.separator, this.outputFile.getName()));
    }

    void setSources(OrderableFileSet[] sources) {
        this.sources = sources;
    }

    void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    void setRepeatedFileStrategy(RepeatedFileStrategy repeatedFileStrategy) {
        this.repeatedFileStrategy = repeatedFileStrategy;
    }

    void setIgnoreEmptySourcesList(boolean ignoreEmptySourcesList) {
        this.ignoreEmptySourcesList = ignoreEmptySourcesList;
    }

    void setDivider(String divider) {
        this.divider = Objects.requireNonNull(divider);
    }

    void setDividerCharset(String dividerCharset) {
        this.dividerCharset = dividerCharset;
    }

    private static class SourceFileNotFoundException
    extends MojoExecutionException {
        public SourceFileNotFoundException(Object source, String shortMessage, String longMessage) {
            super(source, shortMessage, longMessage);
        }

        public SourceFileNotFoundException(String message, Exception cause) {
            super(message, cause);
        }

        public SourceFileNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public SourceFileNotFoundException(String message) {
            super(message);
        }
    }

    private static class BadSourceSpecificationException
    extends MojoExecutionException {
        public BadSourceSpecificationException(Object source, String shortMessage, String longMessage) {
            super(source, shortMessage, longMessage);
        }

        public BadSourceSpecificationException(String message, Exception cause) {
            super(message, cause);
        }

        public BadSourceSpecificationException(String message, Throwable cause) {
            super(message, cause);
        }

        public BadSourceSpecificationException(String message) {
            super(message);
        }
    }

    static class NoYieldFromAnyFilesetsException
    extends MojoExecutionException {
        public NoYieldFromAnyFilesetsException() {
            super("filesets did not yield any files; set ignoreEmptySourceList flag to true if this should be ignored");
        }
    }

    static class NoYieldFromFileSetException
    extends MojoExecutionException {
        public NoYieldFromFileSetException(FileSet fileset, int i) {
            super("fileset at index " + i + " did not yield any files: " + ConcatenateMojo.describeFileset(fileset));
        }
    }

    private static class NoRepeatsSet<E>
    extends LinkedHashSet<E> {
        private NoRepeatsSet() {
        }

        @Override
        public boolean add(E e) {
            boolean result = super.add(e);
            if (!result) {
                throw new RepeatedItemException("add() failed, indicating that element was already in set");
            }
            return true;
        }
    }

    static class RepeatedItemException
    extends IllegalArgumentException {
        public RepeatedItemException(String s) {
            super(s);
        }
    }

    public static enum RepeatedFileStrategy {
        repeat,
        ignore,
        fail;


        public Collection<File> createBucket() {
            switch (this) {
                case repeat: {
                    return new ArrayList<File>();
                }
                case ignore: {
                    return new LinkedHashSet<File>();
                }
                case fail: {
                    return new NoRepeatsSet<File>();
                }
            }
            throw new IllegalStateException("bug: strategy " + (Object)((Object)this) + " not handled");
        }
    }
}

