/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.catmvnplugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;

class Guava {
    private Guava() {
    }

    public static class ByteStreams {
        private ByteStreams() {
        }

        public static long copy(InputStream from, OutputStream to) throws IOException {
            int r;
            Objects.requireNonNull(from);
            Objects.requireNonNull(to);
            byte[] buf = new byte[8192];
            long total = 0L;
            while ((r = from.read(buf)) != -1) {
                to.write(buf, 0, r);
                total += (long)r;
            }
            return total;
        }
    }

    public static class Files {
        private Files() {
        }

        public static void createParentDirs(File file) throws IOException {
            Objects.requireNonNull(file);
            File parent = file.getCanonicalFile().getParentFile();
            if (parent == null) {
                return;
            }
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException("Unable to create parent directories of " + file);
            }
        }
    }

    public static class Strings {
        private Strings() {
        }

        public static boolean isNullOrEmpty(String s) {
            return s == null || s.isEmpty();
        }

        public static String nullToEmpty(@Nullable String s) {
            return s == null ? "" : s;
        }
    }
}

