/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.ProcessKilling;
import com.github.mike10004.xvfbmanager.XvfbManager;
import com.google.common.collect.ImmutableSet;
import io.github.mike10004.subprocess.ProcessMonitor;
import io.github.mike10004.subprocess.ProcessResult;
import io.github.mike10004.subprocess.ProcessTracker;
import io.github.mike10004.subprocess.Subprocess;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDisplayReadinessChecker
implements XvfbManager.DisplayReadinessChecker {
    private static final Logger log = LoggerFactory.getLogger(DefaultDisplayReadinessChecker.class);
    private static final String PROG_XDPYINFO = "xdpyinfo";
    private static final ImmutableSet<String> requiredPrograms = ImmutableSet.of((Object)"xdpyinfo");
    private final ProcessTracker processTracker;
    private static final int XDPYINFO_SIGTERM_TIMEOUT_MILLIS = 1000;

    public DefaultDisplayReadinessChecker(ProcessTracker processTracker) {
        this.processTracker = Objects.requireNonNull(processTracker);
    }

    public static Iterable<String> getRequiredPrograms() {
        return requiredPrograms;
    }

    @Override
    public boolean checkReadiness(String display) {
        ProcessResult result;
        ProcessMonitor monitor = Subprocess.running((String)PROG_XDPYINFO).args("-display", new String[]{display}).build().launcher(this.processTracker).outputStrings(Charset.defaultCharset()).launch();
        try {
            result = monitor.await();
        }
        catch (InterruptedException e) {
            log.error("interrupted while waiting for check readiness", (Throwable)e);
            ProcessKilling.termOrKill(monitor.destructor(), 1000L, TimeUnit.MILLISECONDS);
            return false;
        }
        this.executedCheckProgram((ProcessResult<String, String>)result);
        return this.representsReady((ProcessResult<String, String>)result, display);
    }

    protected boolean representsReady(ProcessResult<String, String> result, String requiredDisplay) {
        if (result.exitCode() != 0) {
            return false;
        }
        return DefaultDisplayReadinessChecker.isCorrectOutputForDisplay((String)result.content().stdout(), requiredDisplay);
    }

    protected static boolean isCorrectOutputForDisplay(String stdout, String requiredDisplay) {
        Pattern pattern = Pattern.compile("^name of display:\\s+" + Pattern.quote(requiredDisplay) + "$", 8);
        return pattern.matcher(stdout).find();
    }

    protected void executedCheckProgram(ProcessResult<String, String> result) {
        LoggerFactory.getLogger(DefaultDisplayReadinessChecker.class).debug("xdpyinfo: {}", result);
    }
}

