/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.ListTreeNode;
import com.github.mike10004.xvfbmanager.Poller;
import com.github.mike10004.xvfbmanager.PollingXLockFileChecker;
import com.github.mike10004.xvfbmanager.Screenshooter;
import com.github.mike10004.xvfbmanager.Sleeper;
import com.github.mike10004.xvfbmanager.TreeNode;
import com.github.mike10004.xvfbmanager.XvfbController;
import com.github.mike10004.xvfbmanager.XvfbException;
import com.github.mike10004.xvfbmanager.XvfbManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import io.github.mike10004.subprocess.ProcessMonitor;
import io.github.mike10004.subprocess.ProcessResult;
import io.github.mike10004.subprocess.ProcessTracker;
import io.github.mike10004.subprocess.Subprocess;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXvfbController
implements XvfbController {
    private static final Logger log = LoggerFactory.getLogger(DefaultXvfbController.class);
    private static final Iterable<String> requiredPrograms = Iterables.concat((Iterable[])new Iterable[]{XWindowPoller.getRequiredPrograms()});
    public static final long DEFAULT_POLL_INTERVAL_MS = 250L;
    public static final int DEFAULT_MAX_NUM_POLLS = 8;
    protected static final long LOCK_FILE_CLEANUP_POLL_INTERVAL_MS = 100L;
    protected static final long LOCK_FILE_CLEANUP_TIMEOUT_MS = 1000L;
    private final ProcessMonitor<?, ?> xvfbMonitor;
    private final String display;
    private final XvfbManager.DisplayReadinessChecker displayReadinessChecker;
    private final XLockFileChecker lockFileChecker;
    private final Screenshooter<?> screenshooter;
    private final Sleeper sleeper;
    private final AtomicBoolean abort;
    private static final int SIGTERM_TIMEOUT_MILLIS = 500;

    public static Iterable<String> getRequiredPrograms() {
        return requiredPrograms;
    }

    public DefaultXvfbController(ProcessMonitor<?, ?> xvfbMonitor, String display, XvfbManager.DisplayReadinessChecker displayReadinessChecker, Screenshooter<?> screenshooter, Sleeper sleeper) {
        this(xvfbMonitor, display, displayReadinessChecker, screenshooter, sleeper, new PollingXLockFileChecker(100L, sleeper));
    }

    @VisibleForTesting
    protected DefaultXvfbController(ProcessMonitor<?, ?> xvfbMonitor, String display, XvfbManager.DisplayReadinessChecker displayReadinessChecker, Screenshooter<?> screenshooter, Sleeper sleeper, XLockFileChecker lockFileChecker) {
        this.xvfbMonitor = Objects.requireNonNull(xvfbMonitor);
        this.display = (String)Preconditions.checkNotNull((Object)display);
        this.displayReadinessChecker = (XvfbManager.DisplayReadinessChecker)Preconditions.checkNotNull((Object)displayReadinessChecker);
        this.screenshooter = (Screenshooter)Preconditions.checkNotNull(screenshooter);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
        this.abort = new AtomicBoolean(false);
        this.lockFileChecker = (XLockFileChecker)Preconditions.checkNotNull((Object)lockFileChecker);
    }

    void setAbort(boolean abort) {
        this.abort.getAndSet(abort);
    }

    @Override
    public void waitUntilReady() throws InterruptedException {
        this.waitUntilReady(250L, 8);
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public Map<String, String> configureEnvironment(Map<String, String> environment) {
        environment.put("DISPLAY", this.display);
        return environment;
    }

    @Override
    public Map<String, String> newEnvironment() {
        return this.configureEnvironment(this.createEmptyMutableMap());
    }

    protected Map<String, String> createEmptyMutableMap() {
        return new HashMap<String, String>();
    }

    private boolean checkAbort() {
        return this.abort.get();
    }

    private String formatXvfbExitedMessage(ProcessResult<?, ?> result) {
        String info = null;
        if (result.exitCode() != 0) {
            info = result.toString();
        }
        return "xvfb already exited with code " + result.exitCode() + (info == null ? "" : ": " + info);
    }

    private boolean isXvfbAlreadyDone() {
        if (this.xvfbMonitor.future().isDone()) {
            try {
                ProcessResult result = this.xvfbMonitor.await();
                String message = this.formatXvfbExitedMessage(result);
                log.error(message);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("ProcessMonitor.await() should return immediately if Future.isDone() is true", e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void waitUntilReady(long pollIntervalMs, int maxNumPolls) throws InterruptedException {
        boolean displayReady;
        Poller.PollOutcome pollResult = new Poller<Boolean>(this.sleeper){

            @Override
            protected Poller.PollAnswer<Boolean> check(int pollAttemptsSoFar) {
                if (DefaultXvfbController.this.isXvfbAlreadyDone()) {
                    return 1.abortPolling();
                }
                if (DefaultXvfbController.this.checkAbort()) {
                    return 1.abortPolling();
                }
                boolean ready = DefaultXvfbController.this.displayReadinessChecker.checkReadiness(DefaultXvfbController.this.display);
                return ready ? 1.resolve(true) : 1.continuePolling();
            }
        }.poll(pollIntervalMs, maxNumPolls);
        boolean bl = displayReady = pollResult.reason == Poller.StopReason.RESOLVED && pollResult.content != null && (Boolean)pollResult.content != false;
        if (!displayReady) {
            throw new XvfbException("display never became ready: " + pollResult);
        }
    }

    @Override
    public void stop() {
        if (this.xvfbMonitor.process().isAlive()) {
            this.xvfbMonitor.destructor().sendTermSignal().await(500L, TimeUnit.MILLISECONDS).kill();
            this.waitForXLockFileCleanup();
        }
    }

    protected void waitForXLockFileCleanup() {
        this.lockFileChecker.waitForCleanup(this.display, 1000L);
    }

    @Override
    public Screenshooter<?> getScreenshooter() throws XvfbException {
        return this.screenshooter;
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public Optional<TreeNode<XvfbController.XWindow>> pollForWindow(Predicate<XvfbController.XWindow> windowFinder, long intervalMs, int maxPollAttempts) throws InterruptedException {
        XWindowPoller poller = new XWindowPoller(this.xvfbMonitor.tracker(), this.display, windowFinder);
        Poller.PollOutcome pollResult = poller.poll(intervalMs, maxPollAttempts);
        return Optional.ofNullable((TreeNode)pollResult.content);
    }

    static abstract class XwininfoParser<E>
    implements LineProcessor<TreeNode<E>> {
        static int COMMON_INDENT = 2;
        static int INDENT_PER_LEVEL = 3;
        private TreeNode<E> root = null;
        private TreeNode<E> prev = null;
        private CharMatcher ws = CharMatcher.whitespace();
        private int previousIndent = 0;

        XwininfoParser() {
        }

        protected boolean skip(String line, String explanation) {
            return true;
        }

        protected abstract E parseWindow(String var1, boolean var2);

        public boolean processLine(String line) {
            if (line.trim().isEmpty()) {
                return this.skip(line, "empty");
            }
            if (line.startsWith("xwininfo:")) {
                return this.skip(line, "header");
            }
            if (line.startsWith("  Parent window id: 0x0 (none)")) {
                return this.skip(line, "extraneous");
            }
            if (line.matches("\\s*\\d+ child(?:ren)?[:.]\\s*")) {
                return this.skip(line, "childcount");
            }
            ListTreeNode<E> current = new ListTreeNode<E>(this.parseWindow(line, this.root == null));
            if (this.root == null) {
                this.root = current;
                this.prev = this.root;
                this.previousIndent = this.measureIndent(line);
                return this.foundRoot(this.root);
            }
            int indent = this.measureIndent(line);
            if (indent == this.previousIndent) {
                TreeNode parent = (TreeNode)Preconditions.checkNotNull(this.prev.getParent(), (Object)"thought prev would not be root");
                parent.addChild(current);
                this.foundSibling(indent, current);
            } else if (indent > this.previousIndent) {
                this.prev.addChild(current);
                this.foundChild(indent, current);
            } else {
                int previousLevels = (this.previousIndent - COMMON_INDENT) / INDENT_PER_LEVEL;
                int levels = (indent - COMMON_INDENT) / INDENT_PER_LEVEL;
                assert (previousLevels > levels);
                TreeNode<E> parent = this.prev.getParent();
                for (int i = 0; i < previousLevels - levels; ++i) {
                    parent = parent.getParent();
                }
                parent.addChild(current);
                this.foundAncestor(indent, current);
            }
            this.previousIndent = indent;
            this.prev = current;
            return true;
        }

        protected void foundAncestor(int indent, TreeNode<E> node) {
        }

        protected void foundSibling(int indent, TreeNode<E> node) {
        }

        protected void foundChild(int indent, TreeNode<E> node) {
        }

        protected boolean foundRoot(TreeNode<E> root) {
            return true;
        }

        private int measureIndent(CharSequence seq) {
            for (int i = 0; i < seq.length(); ++i) {
                char ch = seq.charAt(i);
                if (this.ws.matches(ch)) continue;
                return i;
            }
            return 0;
        }

        public TreeNode<E> getResult() {
            return this.root;
        }

        @VisibleForTesting
        TreeNode<E> parse(CharSource text) throws IOException {
            return (TreeNode)text.readLines((LineProcessor)this);
        }
    }

    static class XwininfoXwindowParser
    extends XwininfoParser<XvfbController.XWindow> {
        static final Pattern linePattern = Pattern.compile("\\s*(0x[a-f0-9]+)\\s((?:\\Q(has no name)\\E)|(?:\".+\")):", 2);

        XwininfoXwindowParser() {
        }

        @Override
        protected XvfbController.XWindow parseWindow(String line, boolean root) {
            String id;
            String title = null;
            if (root) {
                Matcher m = Pattern.compile("\\b0x[a-f0-9]+\\b", 2).matcher(line);
                Preconditions.checkState((boolean)m.find(), (String)"no id found on line %s", (Object)line);
                id = m.group(0);
            } else {
                Matcher m = linePattern.matcher(line);
                if (!m.find()) {
                    throw new IllegalArgumentException("line does not match pattern: " + line);
                }
                id = m.group(1);
                title = m.group(2);
                title = "(has no name)".equals(title) ? null : CharMatcher.is((char)'\"').trimFrom((CharSequence)title);
            }
            return new XvfbController.XWindow(id, title, line);
        }
    }

    private static class XWindowPoller
    extends Poller<TreeNode<XvfbController.XWindow>> {
        private static final String PROG_XWININFO = "xwininfo";
        private static final ImmutableSet<String> requiredPrograms = ImmutableSet.of((Object)"xwininfo");
        private final String display;
        private final Predicate<XvfbController.XWindow> evaluator;
        private final ProcessTracker processTracker;
        private static final int XWININFO_SIGTERM_TIMEOUT_MILLIS = 1000;

        public static Iterable<String> getRequiredPrograms() {
            return requiredPrograms;
        }

        public XWindowPoller(ProcessTracker processTracker, String display, Predicate<XvfbController.XWindow> evaluator) {
            this.processTracker = Objects.requireNonNull(processTracker);
            this.display = (String)Preconditions.checkNotNull((Object)display);
            this.evaluator = (Predicate)Preconditions.checkNotNull(evaluator);
        }

        @Override
        protected Poller.PollAnswer<TreeNode<XvfbController.XWindow>> check(int pollAttemptsSoFar) {
            ProcessMonitor xwininfoMonitor = Subprocess.running((String)PROG_XWININFO).args("-display", new String[]{this.display}).args("-root", new String[]{"-tree"}).build().launcher(this.processTracker).outputStrings(Charset.defaultCharset()).launch();
            ProcessResult result = null;
            try {
                result = xwininfoMonitor.await();
            }
            catch (InterruptedException e) {
                log.error("interrupted while waiting for xwininfo result", (Throwable)e);
                xwininfoMonitor.destructor().sendTermSignal().await(1000L, TimeUnit.MILLISECONDS).kill();
            }
            if (result != null && result.exitCode() == 0) {
                try {
                    XvfbController.XWindow match;
                    TreeNode root = (TreeNode)CharSource.wrap((CharSequence)((CharSequence)result.content().stdout())).readLines((LineProcessor)new XwininfoXwindowParser());
                    XvfbController.XWindow evaluatedNode = null;
                    for (TreeNode treeNode : root.breadthFirstTraversal()) {
                        if (!this.evaluator.test((XvfbController.XWindow)treeNode.getLabel())) continue;
                        evaluatedNode = (XvfbController.XWindow)treeNode.getLabel();
                        break;
                    }
                    if ((match = evaluatedNode) != null) {
                        TreeNode treeNode = (TreeNode)Iterables.find((Iterable)TreeNode.Utils.traverser().breadthFirst((Object)root), input -> match == ((TreeNode)Preconditions.checkNotNull((Object)input)).getLabel());
                        return XWindowPoller.resolve(treeNode);
                    }
                    return XWindowPoller.continuePolling();
                }
                catch (IOException e) {
                    throw new XvfbException(e);
                }
            }
            return XWindowPoller.continuePolling();
        }
    }

    protected static interface XLockFileChecker {
        public void waitForCleanup(String var1, long var2) throws LockFileCheckingException;

        public static class LockFileCleanupTimeoutException
        extends LockFileCheckingException {
            public LockFileCleanupTimeoutException(String message) {
                super(message);
            }
        }

        public static class LockFileCheckingException
        extends XvfbException {
            public LockFileCheckingException() {
            }

            public LockFileCheckingException(String message) {
                super(message);
            }

            public LockFileCheckingException(String message, Throwable cause) {
                super(message, cause);
            }

            public LockFileCheckingException(Throwable cause) {
                super(cause);
            }
        }
    }
}

