/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.Screenshooter;
import com.github.mike10004.xvfbmanager.XvfbException;
import com.github.mike10004.xvfbmanager.XwdFileScreenshot;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class FramebufferDirScreenshooter
implements Screenshooter<XwdFileScreenshot> {
    private final File outputDir;
    private final File framebufferDir;
    private final int screen;

    public FramebufferDirScreenshooter(File framebufferDir, int screen, File outputDir) {
        this.outputDir = (File)Preconditions.checkNotNull((Object)outputDir);
        this.framebufferDir = (File)Preconditions.checkNotNull((Object)framebufferDir);
        this.screen = screen;
    }

    protected String constructFramebufferFilename() {
        return String.format("Xvfb_screen%d", this.screen);
    }

    @Override
    public XwdFileScreenshot capture() throws IOException, XvfbException {
        File outputFile = this.constructOutputPathname(this.outputDir);
        String framebufferFilename = this.constructFramebufferFilename();
        File framebufferFile = new File(this.framebufferDir, framebufferFilename);
        Files.copy((File)framebufferFile, (File)outputFile);
        return XwdFileScreenshot.from(outputFile);
    }

    protected File constructOutputPathname(File outputDir) throws IOException {
        return File.createTempFile("screenshot", ".xwd", outputDir);
    }
}

