/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.TreeNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ListTreeNode<T>
implements TreeNode<T> {
    private TreeNode<T> parent;
    private final T label;
    private List<TreeNode<T>> children;

    public ListTreeNode(T label) {
        this.label = Preconditions.checkNotNull(label, (Object)"label must be non-null");
        this.children = ImmutableList.of();
    }

    @Override
    public T getLabel() {
        return this.label;
    }

    @Override
    public Iterable<TreeNode<T>> children() {
        List<TreeNode<T>> children_ = this.children;
        if (children_ instanceof ImmutableList) {
            return children_;
        }
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getLevel() {
        int level = 0;
        for (TreeNode<T> node = this.parent; node != null; node = node.getParent()) {
            ++level;
        }
        return level;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public TreeNode<T> setParent(TreeNode<T> parent) {
        TreeNode<T> oldParent = this.parent;
        this.parent = parent;
        Preconditions.checkState((boolean)Iterables.contains(parent.children(), (Object)this), (Object)"setParent can only be called on child nodes");
        return oldParent;
    }

    @Override
    public ListTreeNode<T> addChild(TreeNode<T> child) {
        List<TreeNode<T>> children_ = this.children;
        if (children_ instanceof ImmutableList) {
            children_ = new ArrayList<TreeNode<T>>(children_);
            this.children = children_;
        }
        children_.add(child);
        child.setParent(this);
        return this;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public TreeNode.NodeTraversal<T> breadthFirstTraversal() {
        final Iterable bf = TreeNode.Utils.traverser().breadthFirst((Object)this);
        return new TreeNode.NodeTraversal<T>(){

            @Override
            public Iterable<T> labels() {
                Function f = TreeNode.Utils.labelFunction();
                return Iterables.transform((Iterable)bf, f::apply);
            }

            @Override
            public Iterator<TreeNode<T>> iterator() {
                return bf.iterator();
            }
        };
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        int childCount = this.getChildCount();
        boolean leaf = childCount == 0;
        return "ListTreeNode{" + (this.isRoot() ? "root" : (leaf ? "leaf" : "node")) + ", label=" + this.label + ", children.size=" + childCount + '}';
    }
}

