/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.Sleeper;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class Poller<T> {
    private final Sleeper sleeper;

    public Poller() {
        this(Sleeper.DefaultSleeper.getInstance());
    }

    protected Poller(Sleeper sleeper) {
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
    }

    public PollOutcome<T> poll(long intervalMs, int maxNumPolls) throws InterruptedException {
        return this.poll(new RegularIntervals(intervalMs, maxNumPolls));
    }

    public PollOutcome<T> poll(Iterator<Long> intervalsMs) throws InterruptedException {
        StopReason pollResult;
        boolean timeout;
        long startTime = System.currentTimeMillis();
        int numPreviousPollAttempts = 0;
        PollAnswer<T> evaluation = null;
        while (!(timeout = !intervalsMs.hasNext())) {
            long intervalMs = (Long)Preconditions.checkNotNull((Object)intervalsMs.next(), (Object)"interval iterator must return non-nulls");
            Preconditions.checkArgument((intervalMs > 0L ? 1 : 0) != 0, (String)"intervals iterator must return positive values; got %s", (long)intervalMs);
            evaluation = this.checkAndForceNotNull(numPreviousPollAttempts);
            ++numPreviousPollAttempts;
            if (evaluation.action != PollAction.CONTINUE) break;
            this.sleeper.sleep(intervalMs);
        }
        long finishTime = System.currentTimeMillis();
        if (timeout) {
            pollResult = StopReason.TIMEOUT;
        } else if (evaluation.action == PollAction.ABORT) {
            pollResult = StopReason.ABORTED;
        } else if (evaluation.action == PollAction.RESOLVE) {
            pollResult = StopReason.RESOLVED;
        } else {
            throw new IllegalStateException("bug: unexpected combination of timeoutedness and StopReason == " + (Object)((Object)evaluation.action));
        }
        Duration duration = Duration.of(finishTime - startTime, ChronoUnit.MILLIS);
        return new PollOutcome(pollResult, Poller.maybeGetContent(evaluation), duration, numPreviousPollAttempts);
    }

    private PollAnswer<T> checkAndForceNotNull(int numPreviousPollAttempts) {
        PollAnswer<T> answer = this.check(numPreviousPollAttempts);
        Preconditions.checkNotNull(answer, (Object)"check() must return non-null with non-null action");
        return answer;
    }

    @Nullable
    private static <E> E maybeGetContent(@Nullable PollAnswer<E> answer) {
        return answer == null ? null : (E)answer.content;
    }

    protected static <E> PollAnswer<E> resolve(@Nullable E value) {
        return value == null ? PollAnswers.getResolve() : new PollAnswer(PollAction.RESOLVE, value);
    }

    protected static <E> PollAnswer<E> continuePolling() {
        return PollAnswers.getContinue();
    }

    protected static <E> PollAnswer<E> abortPolling(@Nullable E value) {
        return value == null ? PollAnswers.getAbort() : new PollAnswer(PollAction.ABORT, value);
    }

    protected static <E> PollAnswer<E> abortPolling() {
        return Poller.abortPolling(null);
    }

    protected abstract PollAnswer<T> check(int var1);

    public static Poller<Void> checking(Supplier<Boolean> condition) {
        return new SimplePoller(condition);
    }

    protected static class SimplePoller
    extends Poller<Void> {
        private final Supplier<Boolean> condition;

        public SimplePoller(Sleeper sleeper, Supplier<Boolean> condition) {
            super(sleeper);
            this.condition = (Supplier)Preconditions.checkNotNull(condition);
        }

        public SimplePoller(Supplier<Boolean> condition) {
            this.condition = (Supplier)Preconditions.checkNotNull(condition);
        }

        @Override
        protected PollAnswer<Void> check(int pollAttemptsSoFar) {
            boolean state = this.condition.get();
            if (state) {
                return SimplePoller.resolve(null);
            }
            return SimplePoller.continuePolling();
        }
    }

    public static enum PollAction {
        RESOLVE,
        ABORT,
        CONTINUE;

    }

    public static class PollAnswer<E> {
        public final PollAction action;
        @Nullable
        public final E content;

        private PollAnswer(PollAction action, @Nullable E content) {
            this.action = (PollAction)((Object)Preconditions.checkNotNull((Object)((Object)action)));
            this.content = content;
        }
    }

    public static enum StopReason {
        RESOLVED,
        ABORTED,
        TIMEOUT;

    }

    public static class PollOutcome<E> {
        public final StopReason reason;
        @Nullable
        public final E content;
        public final Duration duration;
        private final int numAttempts;

        private PollOutcome(StopReason reason, @Nullable E content, Duration duration, int numAttempts) {
            this.reason = (StopReason)((Object)Preconditions.checkNotNull((Object)((Object)reason)));
            this.content = content;
            this.duration = (Duration)Preconditions.checkNotNull((Object)duration);
            this.numAttempts = numAttempts;
        }

        public String toString() {
            return "PollOutcome{reason=" + (Object)((Object)this.reason) + ", content=" + this.content + ", duration=" + this.duration + ", attempts=" + this.numAttempts + '}';
        }

        public int getNumAttempts() {
            return this.numAttempts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PollOutcome that = (PollOutcome)o;
            if (this.numAttempts != that.numAttempts) {
                return false;
            }
            if (this.reason != that.reason) {
                return false;
            }
            if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
                return false;
            }
            return this.duration.equals(that.duration);
        }

        public int hashCode() {
            int result = this.reason.hashCode();
            result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
            result = 31 * result + this.duration.hashCode();
            result = 31 * result + this.numAttempts;
            return result;
        }
    }

    private static class PollAnswers {
        private static final PollAnswer ABORT_WITH_NULL_VALUE = new PollAnswer(PollAction.ABORT, null);
        private static final PollAnswer RESOLVE_WITH_NULL_VALUE = new PollAnswer(PollAction.RESOLVE, null);
        private static final PollAnswer CONTINUE_WITH_NULL_VALUE = new PollAnswer(PollAction.CONTINUE, null);

        private PollAnswers() {
        }

        public static <E> PollAnswer<E> getAbort() {
            return PollAnswers.getAnswerWithNullValue(PollAction.ABORT);
        }

        public static <E> PollAnswer<E> getResolve() {
            return PollAnswers.getAnswerWithNullValue(PollAction.RESOLVE);
        }

        public static <E> PollAnswer<E> getContinue() {
            return PollAnswers.getAnswerWithNullValue(PollAction.CONTINUE);
        }

        public static <E> PollAnswer<E> getAnswerWithNullValue(PollAction action) {
            Preconditions.checkNotNull((Object)((Object)action), (Object)"action");
            switch (action) {
                case ABORT: {
                    return ABORT_WITH_NULL_VALUE;
                }
                case RESOLVE: {
                    return RESOLVE_WITH_NULL_VALUE;
                }
                case CONTINUE: {
                    return CONTINUE_WITH_NULL_VALUE;
                }
            }
            throw new IllegalStateException("bug: unhandled enum " + (Object)((Object)action));
        }
    }

    protected static class RegularIntervals
    implements Iterator<Long> {
        private final Long intervalMs;
        private final int maxNumPolls;
        private int numPreviousPollAttempts;

        public RegularIntervals(long intervalMs, int maxNumPolls) {
            Preconditions.checkArgument((intervalMs > 0L ? 1 : 0) != 0, (String)"interval must be > 0, not %s", (long)intervalMs);
            this.intervalMs = intervalMs;
            this.maxNumPolls = maxNumPolls;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.numPreviousPollAttempts < this.maxNumPolls;
        }

        @Override
        public synchronized Long next() {
            ++this.numPreviousPollAttempts;
            return this.intervalMs;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported on " + this);
        }
    }
}

