/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.DefaultXvfbController;
import com.github.mike10004.xvfbmanager.Poller;
import com.github.mike10004.xvfbmanager.Sleeper;
import com.github.mike10004.xvfbmanager.XLockFileUtility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;

public class PollingXLockFileChecker
implements DefaultXvfbController.XLockFileChecker {
    private final long pollIntervalMs;
    private final Sleeper sleeper;
    private final XLockFileUtility lockFileUtility;

    public PollingXLockFileChecker(long pollIntervalMs, Sleeper sleeper) {
        this(pollIntervalMs, sleeper, XLockFileUtility.getInstance());
    }

    @VisibleForTesting
    PollingXLockFileChecker(long pollIntervalMs, Sleeper sleeper, XLockFileUtility lockFileUtility) {
        this.pollIntervalMs = pollIntervalMs;
        this.sleeper = sleeper;
        this.lockFileUtility = (XLockFileUtility)Preconditions.checkNotNull((Object)lockFileUtility);
    }

    @Override
    public void waitForCleanup(String display, final long timeoutMs) throws DefaultXvfbController.XLockFileChecker.LockFileCheckingException {
        Poller.PollOutcome pollOutcome;
        File lockFile;
        try {
            lockFile = this.lockFileUtility.constructLockFilePathname(display);
        }
        catch (IOException e) {
            throw new DefaultXvfbController.XLockFileChecker.LockFileCheckingException(e);
        }
        int maxNumPolls = Ints.checkedCast((long)Math.round(Math.ceil((float)timeoutMs / (float)this.pollIntervalMs)));
        final long startTime = System.currentTimeMillis();
        try {
            pollOutcome = new Poller<Void>(this.sleeper){

                @Override
                protected Poller.PollAnswer<Void> check(int pollAttemptsSoFar) {
                    long now = System.currentTimeMillis();
                    if (now - startTime > timeoutMs) {
                        return 1.abortPolling();
                    }
                    return lockFile.exists() ? 1.continuePolling() : 1.resolve(null);
                }
            }.poll(this.pollIntervalMs, maxNumPolls);
        }
        catch (InterruptedException e) {
            throw new DefaultXvfbController.XLockFileChecker.LockFileCheckingException(e);
        }
        if (pollOutcome.reason == Poller.StopReason.ABORTED || pollOutcome.reason == Poller.StopReason.TIMEOUT) {
            throw new DefaultXvfbController.XLockFileChecker.LockFileCleanupTimeoutException(String.format("%s after %s (%d attempts)", new Object[]{pollOutcome.reason, pollOutcome.duration, pollOutcome.getNumAttempts()}));
        }
    }
}

