/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public interface Screenshot {
    public ByteSource asByteSource();

    public static class BasicScreenshot<B extends ByteSource>
    implements Screenshot {
        private final B byteSource;

        public BasicScreenshot(B byteSource) {
            this.byteSource = (ByteSource)Preconditions.checkNotNull(byteSource);
        }

        public B asByteSource() {
            return this.byteSource;
        }
    }

    public static class FileByteSource
    extends ByteSource {
        public final File file;
        private final ByteSource delegate;

        public FileByteSource(File file) {
            this(file, Files.asByteSource((File)file));
        }

        protected FileByteSource(File file, ByteSource delegate) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
            this.delegate = (ByteSource)Preconditions.checkNotNull((Object)delegate);
        }

        public CharSource asCharSource(Charset charset) {
            return this.delegate.asCharSource(charset);
        }

        public InputStream openStream() throws IOException {
            return this.delegate.openStream();
        }

        public InputStream openBufferedStream() throws IOException {
            return this.delegate.openBufferedStream();
        }

        public ByteSource slice(long offset, long length) {
            return this.delegate.slice(offset, length);
        }

        public boolean isEmpty() throws IOException {
            return this.delegate.isEmpty();
        }

        @Beta
        public Optional<Long> sizeIfKnown() {
            return this.delegate.sizeIfKnown();
        }

        public long size() throws IOException {
            return this.delegate.size();
        }

        public long copyTo(OutputStream output) throws IOException {
            return this.delegate.copyTo(output);
        }

        public long copyTo(ByteSink sink) throws IOException {
            return this.delegate.copyTo(sink);
        }

        public byte[] read() throws IOException {
            return this.delegate.read();
        }

        @Beta
        public <T> T read(ByteProcessor<T> processor) throws IOException {
            return (T)this.delegate.read(processor);
        }

        public HashCode hash(HashFunction hashFunction) throws IOException {
            return this.delegate.hash(hashFunction);
        }

        public boolean contentEquals(ByteSource other) throws IOException {
            return this.delegate.contentEquals(other);
        }
    }
}

