/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import io.github.mike10004.subprocess.ProcessTracker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class ShutdownHookProcessTracker
implements ProcessTracker {
    private static final Logger log = LoggerFactory.getLogger(ShutdownHookProcessTracker.class);
    private final AntProcessDestroyer destroyer = new AntProcessDestroyer();
    private static final Supplier<ProcessTracker> INSTANCE = Suppliers.memoize(ShutdownHookProcessTracker::new);

    public static ProcessTracker getInstance() {
        return INSTANCE.get();
    }

    public synchronized void add(Process process) {
        this.destroyer.add(process);
    }

    public synchronized boolean remove(Process process) {
        boolean removed = this.destroyer.remove(process);
        if (!removed) {
            log.debug("not removed (probably not still in processes set): {}", (Object)process);
        }
        return removed;
    }

    public synchronized int activeCount() {
        return this.destroyer.processes.size();
    }

    @VisibleForTesting
    List<Process> destroyAll(long timeout, TimeUnit unit) {
        return this.destroyer.destroyAll(timeout, unit);
    }

    private static class AntProcessDestroyer
    implements Runnable {
        private static final int THREAD_DIE_TIMEOUT = 20000;
        private HashSet<Process> processes = new HashSet();
        private Method addShutdownHookMethod;
        private Method removeShutdownHookMethod;
        private ProcessDestroyerImpl destroyProcessThread = null;
        private boolean added = false;
        private boolean running = false;

        AntProcessDestroyer() {
            try {
                Class[] paramTypes = new Class[]{Thread.class};
                this.addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", paramTypes);
                this.removeShutdownHookMethod = Runtime.class.getMethod("removeShutdownHook", paramTypes);
            }
            catch (NoSuchMethodException paramTypes) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void addShutdownHook() {
            if (this.addShutdownHookMethod != null && !this.running) {
                this.destroyProcessThread = new ProcessDestroyerImpl();
                Object[] args = new Object[]{this.destroyProcessThread};
                try {
                    this.addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), args);
                    this.added = true;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t != null && t.getClass() == IllegalStateException.class) {
                        this.running = true;
                    }
                    e.printStackTrace();
                }
            }
        }

        private void removeShutdownHook() {
            if (this.removeShutdownHookMethod != null && this.added && !this.running) {
                Object[] args = new Object[]{this.destroyProcessThread};
                try {
                    Boolean removed = (Boolean)this.removeShutdownHookMethod.invoke((Object)Runtime.getRuntime(), args);
                    if (!removed.booleanValue()) {
                        System.err.println("Could not remove shutdown hook");
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t != null && t.getClass() == IllegalStateException.class) {
                        this.running = true;
                    }
                    e.printStackTrace();
                }
                this.destroyProcessThread.setShouldDestroy(false);
                if (!this.destroyProcessThread.getThreadGroup().isDestroyed()) {
                    this.destroyProcessThread.start();
                }
                try {
                    this.destroyProcessThread.join(20000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.destroyProcessThread = null;
                this.added = false;
            }
        }

        public boolean isAddedAsShutdownHook() {
            return this.added;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Process process) {
            HashSet<Process> hashSet = this.processes;
            synchronized (hashSet) {
                if (this.processes.size() == 0) {
                    this.addShutdownHook();
                }
                return this.processes.add(process);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Process process) {
            HashSet<Process> hashSet = this.processes;
            synchronized (hashSet) {
                boolean processRemoved = this.processes.remove(process);
                if (processRemoved && this.processes.size() == 0) {
                    this.removeShutdownHook();
                }
                return processRemoved;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<Process> hashSet = this.processes;
            synchronized (hashSet) {
                this.running = true;
                Iterator<Process> e = this.processes.iterator();
                while (e.hasNext()) {
                    e.next().destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Process> destroyAll(long timeoutPerProcess, TimeUnit unit) {
            HashSet<Process> hashSet = this.processes;
            synchronized (hashSet) {
                List undestroyed = ProcessTracker.destroyAll(this.processes, (long)timeoutPerProcess, (TimeUnit)unit);
                this.processes.retainAll(undestroyed);
                return undestroyed;
            }
        }

        private class ProcessDestroyerImpl
        extends Thread {
            private boolean shouldDestroy;

            public ProcessDestroyerImpl() {
                super("ProcessDestroyer Shutdown Hook");
                this.shouldDestroy = true;
            }

            @Override
            public void run() {
                if (this.shouldDestroy) {
                    AntProcessDestroyer.this.run();
                }
            }

            public void setShouldDestroy(boolean shouldDestroy) {
                this.shouldDestroy = shouldDestroy;
            }
        }
    }
}

