/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.function.Function;

public interface TreeNode<T> {
    public Iterable<TreeNode<T>> children();

    public NodeTraversal<T> breadthFirstTraversal();

    public int getLevel();

    public int getChildCount();

    public TreeNode<T> getParent();

    public TreeNode<T> setParent(TreeNode<T> var1);

    public boolean isRoot();

    public T getLabel();

    public TreeNode<T> addChild(TreeNode<T> var1);

    public boolean isLeaf();

    public static class Utils {
        private Utils() {
        }

        public static <E> Traverser<TreeNode<E>> traverser() {
            return Traverser.forTree((SuccessorsFunction)new SuccessorsFunction<TreeNode<E>>(){

                public Iterable<? extends TreeNode<E>> successors(TreeNode<E> node) {
                    return node.children();
                }
            });
        }

        public static <E> Function<TreeNode<E>, Iterable<TreeNode<E>>> childrenFunction() {
            return new Function<TreeNode<E>, Iterable<TreeNode<E>>>(){

                @Override
                public Iterable<TreeNode<E>> apply(TreeNode<E> input) {
                    return input.children();
                }
            };
        }

        public static <E> Function<TreeNode<E>, E> labelFunction() {
            return new Function<TreeNode<E>, E>(){

                @Override
                public E apply(TreeNode<E> input) {
                    return input.getLabel();
                }
            };
        }
    }

    public static interface NodeTraversal<T>
    extends Iterable<TreeNode<T>> {
        public Iterable<T> labels();
    }
}

