/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

class XLockFileUtility {
    private static final Function<String, String> systemEnvironment = new Function<String, String>(){

        @Override
        @Nullable
        public String apply(String name) {
            return System.getenv(name);
        }
    };
    private final Function<String, String> environment;
    private static final XLockFileUtility instance = new XLockFileUtility();
    private static final String[] tmpdirEnvironmentVariableNames = new String[]{"TMP", "TMPDIR", "TEMP"};

    private XLockFileUtility() {
        this(XLockFileUtility.systemEnvironment());
    }

    public static XLockFileUtility getInstance() {
        return instance;
    }

    @VisibleForTesting
    protected XLockFileUtility(Function<String, String> environment) {
        this.environment = (Function)Preconditions.checkNotNull(environment);
    }

    private static final Function<String, String> systemEnvironment() {
        return systemEnvironment;
    }

    public File constructLockFilePathname(String display) throws IOException {
        Preconditions.checkArgument((boolean)display.matches(":\\d+"), (String)"invalid display: '%s' (expected format ':N')", (Object)display);
        int displayNum = Integer.parseInt(display.substring(1));
        String filename = this.constructLockFilename(displayNum);
        File parent = this.getXLockFileParentPath();
        return new File(parent, filename);
    }

    protected File getXLockFileParentPath() throws FileNotFoundException {
        String path = "/tmp";
        for (String envVarName : tmpdirEnvironmentVariableNames) {
            String envVarValue = this.environment.apply(envVarName);
            if (envVarValue == null) continue;
            return new File(envVarValue);
        }
        File dir = new File(path);
        return dir.isDirectory() ? dir : FileUtils.getTempDirectory();
    }

    protected String constructLockFilename(int displayNum) {
        return ".X" + displayNum + "-lock";
    }
}

