/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.Screenshooter;
import com.github.mike10004.xvfbmanager.TreeNode;
import com.github.mike10004.xvfbmanager.XvfbException;
import java.io.Closeable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public interface XvfbController
extends Closeable {
    public static final String ENV_DISPLAY = "DISPLAY";

    public void waitUntilReady() throws InterruptedException;

    public void waitUntilReady(long var1, int var3) throws InterruptedException;

    public void stop();

    public String getDisplay();

    public Map<String, String> configureEnvironment(Map<String, String> var1);

    public Map<String, String> newEnvironment();

    public Screenshooter<?> getScreenshooter() throws XvfbException;

    public Optional<TreeNode<XWindow>> pollForWindow(Predicate<XWindow> var1, long var2, int var4) throws InterruptedException;

    public static class XWindow {
        public final String id;
        @Nullable
        public final String title;
        public final String line;

        public XWindow(String id, @Nullable String title, String line) {
            this.id = id;
            this.title = title;
            this.line = line;
        }

        public String toString() {
            return "XWindow{id=" + this.id + ", title='" + this.title + '\'' + ", length=" + (this.line == null ? -1 : this.line.length()) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XWindow xWindow = (XWindow)o;
            if (this.id != null ? !this.id.equals(xWindow.id) : xWindow.id != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(xWindow.title) : xWindow.title != null) {
                return false;
            }
            return this.line != null ? this.line.equals(xWindow.line) : xWindow.line == null;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }
}

