/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.nativehelper.Whicher;
import com.github.mike10004.xvfbmanager.DefaultDisplayReadinessChecker;
import com.github.mike10004.xvfbmanager.DefaultXvfbController;
import com.github.mike10004.xvfbmanager.FramebufferDirScreenshooter;
import com.github.mike10004.xvfbmanager.Poller;
import com.github.mike10004.xvfbmanager.Screenshooter;
import com.github.mike10004.xvfbmanager.ShutdownHookProcessTracker;
import com.github.mike10004.xvfbmanager.Sleeper;
import com.github.mike10004.xvfbmanager.XvfbConfig;
import com.github.mike10004.xvfbmanager.XvfbController;
import com.github.mike10004.xvfbmanager.XvfbException;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.mike10004.subprocess.ProcessMonitor;
import io.github.mike10004.subprocess.ProcessResult;
import io.github.mike10004.subprocess.ProcessTracker;
import io.github.mike10004.subprocess.Subprocess;
import io.github.mike10004.subprocess.UniformSubprocessLaunchSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XvfbManager {
    private static final Logger log = LoggerFactory.getLogger(XvfbManager.class);
    private static final int SCREEN = 0;
    private final Supplier<File> xvfbExecutableSupplier;
    private final XvfbConfig xvfbConfig;
    private final ProcessTracker processTracker;
    private static final int DISPLAY_RECEIVER_FD = 2;
    private static final Charset XVFB_OUTPUT_CHARSET = Charset.defaultCharset();
    private static final long AUTO_DISPLAY_POLL_INTERVAL_MS = 100L;
    private static final int AUTO_DISPLAY_POLLS_MAX = 20;

    public XvfbManager() {
        this(XvfbManager.createXvfbExecutableResolver(), XvfbConfig.getDefault());
    }

    public XvfbManager(XvfbConfig xvfbConfig) {
        this(XvfbManager.createXvfbExecutableResolver(), xvfbConfig);
    }

    public XvfbManager(File xvfbExecutable, XvfbConfig xvfbConfig) {
        this((Supplier<File>)Suppliers.ofInstance((Object)((File)Preconditions.checkNotNull((Object)xvfbExecutable, (Object)"xvfbExecutable must be non-null; use Supplier of null instance if null is desired"))), xvfbConfig);
    }

    public XvfbManager(Supplier<File> xvfbExecutableSupplier, XvfbConfig xvfbConfig) {
        this(xvfbExecutableSupplier, xvfbConfig, ShutdownHookProcessTracker.getInstance());
    }

    public XvfbManager(ProcessTracker processTracker) {
        this(XvfbManager.createXvfbExecutableResolver(), XvfbConfig.getDefault(), processTracker);
    }

    public XvfbManager(Supplier<File> xvfbExecutableSupplier, XvfbConfig xvfbConfig, ProcessTracker processTracker) {
        this.xvfbExecutableSupplier = (Supplier)Preconditions.checkNotNull(xvfbExecutableSupplier);
        this.xvfbConfig = (XvfbConfig)Preconditions.checkNotNull((Object)xvfbConfig);
        this.processTracker = Objects.requireNonNull(processTracker);
    }

    protected static String toDisplayValue(int displayNumber) {
        Preconditions.checkArgument((displayNumber >= 0 ? 1 : 0) != 0, (Object)"displayNumber must be nonnegative");
        return String.format(":%d", displayNumber);
    }

    protected static Supplier<File> createXvfbExecutableResolver() {
        return new Supplier<File>(){

            @Override
            public File get() {
                try {
                    return XvfbManager.resolveXvfbExecutable();
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }

            public String toString() {
                return "DefaultXvfbExecutableResolver";
            }
        };
    }

    protected static File resolveXvfbExecutable() throws FileNotFoundException {
        Optional file = Whicher.gnu().which("Xvfb");
        if (!file.isPresent()) {
            throw new FileNotFoundException("Xvfb executable");
        }
        return (File)file.get();
    }

    protected Screenshooter<?> createScreenshooter(String display, File framebufferDir) {
        return new FramebufferDirScreenshooter(framebufferDir, 0, framebufferDir);
    }

    protected Sleeper createSleeper() {
        return Sleeper.DefaultSleeper.getInstance();
    }

    protected DisplayReadinessChecker createDisplayReadinessChecker(ProcessTracker tracker, String display, File framebufferDir) {
        return new DefaultDisplayReadinessChecker(tracker);
    }

    protected DefaultXvfbController createController(ProcessMonitor<File, File> future, String display, File framebufferDir) {
        return new DefaultXvfbController(future, display, this.createDisplayReadinessChecker(this.processTracker, display, framebufferDir), this.createScreenshooter(display, framebufferDir), this.createSleeper());
    }

    public XvfbController start(int displayNumber, Path scratchDir) throws IOException {
        return this.doStart(displayNumber, XvfbManager.nonDeletingExistingDirectoryProvider(scratchDir));
    }

    public XvfbController start(int displayNumber) throws IOException {
        return this.doStart(displayNumber, XvfbManager.newTempDirProvider(FileUtils.getTempDirectory().toPath()));
    }

    public XvfbController start() throws IOException {
        return this.doStart(null, XvfbManager.newTempDirProvider(FileUtils.getTempDirectory().toPath()));
    }

    public XvfbController start(Path scratchDir) throws IOException {
        return this.doStart(null, XvfbManager.nonDeletingExistingDirectoryProvider(scratchDir));
    }

    private XvfbController doStart(@Nullable Integer displayNumber, ScratchDirProvider scratchDirProvider) throws IOException {
        String display = null;
        boolean AUTO_DISPLAY = displayNumber == null;
        File xvfbExecutable = this.xvfbExecutableSupplier.get();
        Subprocess.Builder pb = xvfbExecutable == null ? Subprocess.running((String)"Xvfb") : Subprocess.running((File)xvfbExecutable);
        if (AUTO_DISPLAY) {
            pb.args("-displayfd", new String[]{String.valueOf(2)});
        } else {
            display = XvfbManager.toDisplayValue(displayNumber);
            pb.args(display, new String[0]);
        }
        Path scratchDir = scratchDirProvider.provideDirectory();
        Path framebufferDir = Files.createTempDirectory(scratchDir, "xvfb-framebuffer", new FileAttribute[0]);
        pb.args("-screen", new String[]{String.valueOf(0), this.xvfbConfig.geometry});
        pb.args("-fbdir", new String[]{framebufferDir.toAbsolutePath().toString()});
        File stdoutFile = File.createTempFile("xvfb-stdout", ".txt", scratchDir.toFile());
        File stderrFile = File.createTempFile("xvfb-stderr", ".txt", scratchDir.toFile());
        Subprocess xvfbSubprocess = pb.build();
        log.trace("executing {}", (Object)xvfbSubprocess);
        UniformSubprocessLaunchSupport launcher = xvfbSubprocess.launcher(this.processTracker).outputFiles(stdoutFile, stderrFile);
        ProcessMonitor xvfbMonitor = launcher.launch();
        Executor callbacker = this.getCallbackExecutor();
        Futures.addCallback((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)xvfbMonitor.future()), new LoggingCallback("xvfb"), (Executor)callbacker);
        if (scratchDirProvider.isDeleteOnStop()) {
            Futures.addCallback((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)xvfbMonitor.future()), new DirectoryDeletingCallback(scratchDir.toFile()), (Executor)callbacker);
        }
        if (AUTO_DISPLAY) {
            File outputFileContainingDisplay = XvfbManager.selectCorrespondingFile(2, stdoutFile, stderrFile);
            int autoDisplayNumber = this.pollForDisplayNumber(com.google.common.io.Files.asCharSource((File)outputFileContainingDisplay, (Charset)XVFB_OUTPUT_CHARSET));
            display = XvfbManager.toDisplayValue(autoDisplayNumber);
        } else {
            Preconditions.checkState((display != null ? 1 : 0) != 0, (String)"display should have been set manually from %s", (Object)displayNumber);
        }
        DefaultXvfbController controller = this.createController((ProcessMonitor<File, File>)xvfbMonitor, display, framebufferDir.toFile());
        Futures.addCallback((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)xvfbMonitor.future()), new AbortFlagSetter(controller), (Executor)callbacker);
        return controller;
    }

    protected Executor getCallbackExecutor() {
        return MoreExecutors.directExecutor();
    }

    protected static File selectCorrespondingFile(int fd, File stdoutFile, File stderrFile) throws IllegalArgumentException {
        switch (fd) {
            case 1: {
                return stdoutFile;
            }
            case 2: {
                return stderrFile;
            }
        }
        throw new IllegalArgumentException("no known file corresponds to " + fd);
    }

    protected static ScratchDirProvider nonDeletingExistingDirectoryProvider(final Path directory) {
        return new ScratchDirProvider(){

            @Override
            public Path provideDirectory() {
                return directory;
            }

            @Override
            public boolean isDeleteOnStop() {
                return false;
            }
        };
    }

    protected static ScratchDirProvider newTempDirProvider(final Path parent) {
        return new ScratchDirProvider(){

            @Override
            public Path provideDirectory() throws IOException {
                return Files.createTempDirectory(parent, "xvfb-manager", new FileAttribute[0]);
            }

            @Override
            public boolean isDeleteOnStop() {
                return true;
            }
        };
    }

    protected int pollForDisplayNumber(final CharSource cs) {
        Poller.PollOutcome pollOutcome;
        Poller<Integer> poller = new Poller<Integer>(){

            @Override
            protected Poller.PollAnswer<Integer> check(int pollAttemptsSoFar) {
                String lastLine = null;
                try {
                    lastLine = (String)Iterables.getFirst((Iterable)cs.readLines().reverse(), null);
                }
                catch (IOException e) {
                    log.info("failed to read from {}", (Object)cs);
                }
                if (lastLine != null) {
                    if ((lastLine = lastLine.trim()).matches("\\d+")) {
                        int displayNumber = Integer.parseInt(lastLine);
                        return 4.resolve(displayNumber);
                    }
                    log.debug("last line of xvfb output is not an integer: {}", (Object)StringUtils.abbreviate((String)lastLine, (int)128));
                }
                return 4.continuePolling();
            }
        };
        try {
            pollOutcome = poller.poll(100L, 20);
        }
        catch (InterruptedException e) {
            throw new XvfbException("interrupted while polling for display number", e);
        }
        if (pollOutcome.reason == Poller.StopReason.RESOLVED) {
            assert (pollOutcome.content != null) : "poll resolved but outcome content is null";
            return (Integer)pollOutcome.content;
        }
        throw new XvfbException("polling for display number (because of -displayfd option) did not behave as expected; poll terminated due to " + (Object)((Object)pollOutcome.reason));
    }

    public ProcessTracker getProcessTracker() {
        return this.processTracker;
    }

    public String toString() {
        return "XvfbManager{xvfbExecutableSupplier=" + this.xvfbExecutableSupplier + ", xvfbConfig=" + this.xvfbConfig + ", processTracker=" + this.processTracker + '}';
    }

    static class DirectoryDeletingCallback<T>
    implements FutureCallback<ProcessResult<T, T>> {
        private final File directory;

        DirectoryDeletingCallback(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory);
        }

        public void onSuccess(@Nullable ProcessResult<T, T> result) {
            this.deleteDirectory();
        }

        public void onFailure(Throwable t) {
            this.deleteDirectory();
        }

        protected void deleteDirectory() {
            block2: {
                try {
                    FileUtils.deleteDirectory((File)this.directory);
                }
                catch (IOException e) {
                    if (!this.directory.exists()) break block2;
                    LoggerFactory.getLogger(DirectoryDeletingCallback.class).info("failed to delete directory {}: {}", (Object)this.directory, (Object)e.toString());
                }
            }
        }
    }

    static class LoggingCallback<T>
    implements FutureCallback<T> {
        private final String name;

        public LoggingCallback(String name) {
            this.name = name;
        }

        public void onSuccess(T result) {
            if (result instanceof ProcessResult && ((ProcessResult)result).exitCode() != 0) {
                log.info("{}: {}", (Object)this.name, result);
            } else {
                log.debug("{}: {}", (Object)this.name, result);
            }
        }

        public void onFailure(Throwable t) {
            if (t instanceof CancellationException) {
                log.debug("{}: cancelled", (Object)this.name);
            } else {
                log.info("{}: {}", (Object)this.name, (Object)t);
            }
        }
    }

    public static interface DisplayReadinessChecker {
        public boolean checkReadiness(String var1);
    }

    private static class AbortFlagSetter<T>
    implements FutureCallback<ProcessResult<T, T>> {
        private final DefaultXvfbController xvfbController;

        private AbortFlagSetter(DefaultXvfbController xvfbController) {
            this.xvfbController = xvfbController;
        }

        public void onSuccess(ProcessResult<T, T> result) {
        }

        public void onFailure(Throwable t) {
            this.xvfbController.setAbort(true);
        }
    }

    static interface ScratchDirProvider {
        public Path provideDirectory() throws IOException;

        public boolean isDeleteOnStop();
    }
}

