/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.ImageioReadableScreenshot;
import com.github.mike10004.xvfbmanager.ProcessKilling;
import com.github.mike10004.xvfbmanager.Screenshot;
import com.github.mike10004.xvfbmanager.ScreenshotConverter;
import com.github.mike10004.xvfbmanager.XvfbException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.github.mike10004.subprocess.ProcessMonitor;
import io.github.mike10004.subprocess.ProcessResult;
import io.github.mike10004.subprocess.ProcessTracker;
import io.github.mike10004.subprocess.Subprocess;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XwdFileToPngConverter
implements ScreenshotConverter<Screenshot, ImageioReadableScreenshot> {
    private static final Logger log = LoggerFactory.getLogger(XwdFileToPngConverter.class);
    private static final String PROG_XWDTOPNM = "xwdtopnm";
    private static final ImmutableSet<String> requiredPrograms = ImmutableSet.of((Object)"xwdtopnm");
    private final ProcessTracker processTracker;
    private final Path tempDir;

    public XwdFileToPngConverter(ProcessTracker processTracker, Path tempDir) {
        this.tempDir = (Path)Preconditions.checkNotNull((Object)tempDir);
        this.processTracker = Objects.requireNonNull(processTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageioReadableScreenshot convert(Screenshot source) throws IOException, XvfbException {
        File pnmFile = File.createTempFile("xwdtopnm-stdout", ".ppm", this.tempDir.toFile());
        try {
            ImageioReadableScreenshot imageioReadableScreenshot = this.convert(source, pnmFile);
            return imageioReadableScreenshot;
        }
        finally {
            if (!pnmFile.delete()) {
                log.info("failed to delete {}", (Object)pnmFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageioReadableScreenshot convert(Screenshot source, File pnmFile) throws IOException, XvfbException {
        File stderrFile = File.createTempFile("xwdtopnm-stderr", ".txt", this.tempDir.toFile());
        try {
            ImageioReadableScreenshot imageioReadableScreenshot = this.convert(source, pnmFile, stderrFile);
            return imageioReadableScreenshot;
        }
        finally {
            if (!stderrFile.delete()) {
                log.info("failed to delete {}", (Object)stderrFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageioReadableScreenshot convert(Screenshot source, File pnmFile, File stderrFile) throws IOException, XvfbException {
        boolean deleteInputFile;
        File inputFile;
        ByteSource inputSource = source.asByteSource();
        if (inputSource instanceof Screenshot.FileByteSource) {
            inputFile = ((Screenshot.FileByteSource)inputSource).file;
            deleteInputFile = false;
        } else {
            inputFile = File.createTempFile("xwdtopnm-stdin", ".xwd", this.tempDir.toFile());
            inputSource.copyTo(Files.asByteSink((File)inputFile, (FileWriteMode[])new FileWriteMode[0]));
            deleteInputFile = true;
        }
        try {
            ImageioReadableScreenshot imageioReadableScreenshot = this.convert(pnmFile, stderrFile, inputFile);
            return imageioReadableScreenshot;
        }
        finally {
            if (deleteInputFile && !inputFile.delete()) {
                log.info("failed to delete {}", (Object)inputFile);
            }
        }
    }

    protected ImageioReadableScreenshot convert(File pnmFile, File stderrFile, File inputFile) throws IOException, XvfbException {
        if (!inputFile.isFile()) {
            throw new FileNotFoundException(inputFile.getAbsolutePath());
        }
        if (inputFile.length() <= 0L) {
            throw new IOException("input file is empty: " + inputFile);
        }
        ProcessMonitor xwdtopnm = Subprocess.running((String)PROG_XWDTOPNM).args("-", new String[0]).build().launcher(this.processTracker).outputFiles(pnmFile, stderrFile, () -> ((ByteSource)Files.asByteSource((File)inputFile)).openStream()).launch();
        ProcessResult result = null;
        try {
            result = xwdtopnm.await();
        }
        catch (InterruptedException e) {
            ProcessKilling.termOrKill(xwdtopnm.destructor(), 250L, TimeUnit.MILLISECONDS);
            throw new IOException("interrupted while waiting for xwdtopnm to finish", e);
        }
        log.debug("xwdtopnm: {}", (Object)result);
        if (result.exitCode() != 0) {
            String stderrText = Files.asCharSource((File)stderrFile, (Charset)Charset.defaultCharset()).read();
            throw new IOException("xwdtopnm failed with exit code " + result.exitCode() + ": " + StringUtils.abbreviate((String)stderrText, (int)256));
        }
        byte[] pngBytes = this.convertPnmToPng(Files.asByteSource((File)pnmFile));
        return new ImageioReadableScreenshot(ByteSource.wrap((byte[])pngBytes));
    }

    protected byte[] convertPnmToPng(ByteSource pnmBytes) throws IOException {
        try (InputStream in = pnmBytes.openStream();){
            byte[] byArray;
            BufferedImage image = ImageIO.read(in);
            if (image == null) {
                throw new IOException("no PNM image reader is registered");
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(2048);){
                ImageIO.write((RenderedImage)image, "png", (OutputStream)out);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public static Iterable<String> getRequiredPrograms() {
        return requiredPrograms;
    }
}

