/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbmanager;

import com.github.mike10004.xvfbmanager.ProcessKilling;
import com.github.mike10004.xvfbmanager.Screenshooter;
import com.github.mike10004.xvfbmanager.XvfbException;
import com.github.mike10004.xvfbmanager.XwdFileScreenshot;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.github.mike10004.subprocess.ProcessMonitor;
import io.github.mike10004.subprocess.ProcessResult;
import io.github.mike10004.subprocess.ProcessTracker;
import io.github.mike10004.subprocess.Subprocess;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XwdScreenshooter
implements Screenshooter<XwdFileScreenshot> {
    private static final String PROG_XWD = "xwd";
    private static final ImmutableSet<String> requiredPrograms = ImmutableSet.of((Object)"xwd");
    private static final Logger log = LoggerFactory.getLogger(XwdScreenshooter.class);
    private final ProcessTracker processTracker;
    private final String display;
    private final File outputDir;

    public static Iterable<String> getRequiredPrograms() {
        return requiredPrograms;
    }

    public XwdScreenshooter(ProcessTracker processTracker, String display, File outputDir) {
        this.processTracker = Objects.requireNonNull(processTracker);
        this.display = (String)Preconditions.checkNotNull((Object)display);
        this.outputDir = (File)Preconditions.checkNotNull((Object)outputDir);
    }

    @Override
    public XwdFileScreenshot capture() throws IOException, XvfbException {
        ProcessResult xwdResult;
        File xwdFile = File.createTempFile("screenshot", ".xwd", this.outputDir);
        ProcessMonitor xwdMonitor = Subprocess.running((String)PROG_XWD).args("-display", new String[]{this.display, "-root", "-silent", "-out", xwdFile.getAbsolutePath()}).build().launcher(this.processTracker).outputStrings(Charset.defaultCharset()).launch();
        try {
            xwdResult = xwdMonitor.await();
        }
        catch (InterruptedException e) {
            log.error("interrupted while waiting for xwd", (Throwable)e);
            ProcessKilling.termOrKill(xwdMonitor.destructor(), 100L, TimeUnit.MILLISECONDS);
            throw new Screenshooter.ScreenshooterException("failed to take screenshot due to interruption", e);
        }
        log.debug("xwd process finished: {}", (Object)xwdResult);
        String stderrText = StringUtils.abbreviate((String)((String)xwdResult.content().stderr()), (int)512);
        if (xwdResult.exitCode() != 0) {
            throw new Screenshooter.ScreenshooterException("xwd failed with code " + xwdResult.exitCode() + " and stderr: " + stderrText);
        }
        return XwdFileScreenshot.from(xwdFile);
    }
}

