/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.api;

import com.github.mikesafonov.smpp.api.NoSenderClientException;
import com.github.mikesafonov.smpp.api.SenderManager;
import com.github.mikesafonov.smpp.config.SmscConnection;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public abstract class BaseSenderManager
implements SenderManager {
    protected final List<SmscConnection> smscConnections;

    protected BaseSenderManager(@NotNull List<SmscConnection> smscConnections) {
        this.smscConnections = Objects.requireNonNull(smscConnections);
    }

    @Override
    public SenderClient getByName(@NotBlank String name) {
        return this.smscConnections.stream().filter(smscConnection -> smscConnection.getName().equals(name)).findFirst().map(SmscConnection::getSenderClient).orElseThrow(NoSenderClientException::new);
    }

    protected boolean isEmpty() {
        return this.smscConnections.isEmpty();
    }

    protected int size() {
        return this.smscConnections.size();
    }
}

