/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.api;

import com.github.mikesafonov.smpp.api.BaseSenderManager;
import com.github.mikesafonov.smpp.api.IndexDetectionStrategy;
import com.github.mikesafonov.smpp.api.NoSenderClientException;
import com.github.mikesafonov.smpp.config.SmscConnection;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class StrategySenderManager
extends BaseSenderManager {
    private final IndexDetectionStrategy indexDetectionStrategy;

    public StrategySenderManager(@NotNull List<SmscConnection> smscConnections, @NotNull IndexDetectionStrategy indexDetectionStrategy) {
        super(smscConnections);
        this.indexDetectionStrategy = Objects.requireNonNull(indexDetectionStrategy);
    }

    @Override
    public SenderClient getClient() {
        if (this.isEmpty()) {
            throw new NoSenderClientException();
        }
        int nextIndex = this.indexDetectionStrategy.next(this.size());
        return ((SmscConnection)this.smscConnections.get(nextIndex)).getSenderClient();
    }
}

