/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.config;

import com.github.mikesafonov.smpp.api.RoundRobinIndexDetectionStrategy;
import com.github.mikesafonov.smpp.api.SenderManager;
import com.github.mikesafonov.smpp.api.StrategySenderManager;
import com.github.mikesafonov.smpp.config.SmppProperties;
import com.github.mikesafonov.smpp.config.SmscConnectionFactoryBean;
import com.github.mikesafonov.smpp.config.SmscConnectionsHolder;
import com.github.mikesafonov.smpp.core.ClientFactory;
import com.github.mikesafonov.smpp.core.connection.ConnectionManagerFactory;
import com.github.mikesafonov.smpp.core.generators.AlwaysSuccessSmppResultGenerator;
import com.github.mikesafonov.smpp.core.generators.SmppResultGenerator;
import com.github.mikesafonov.smpp.core.reciever.DeliveryReportConsumer;
import com.github.mikesafonov.smpp.core.sender.DefaultTypeOfAddressParser;
import com.github.mikesafonov.smpp.core.sender.TypeOfAddressParser;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SmppProperties.class})
public class SmppAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmppAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={TypeOfAddressParser.class})
    public TypeOfAddressParser defaultTypeOfAddressParser() {
        return new DefaultTypeOfAddressParser();
    }

    @Bean
    public ClientFactory clientFactory() {
        return new ClientFactory();
    }

    @Bean
    public ConnectionManagerFactory connectionManagerFactory() {
        return new ConnectionManagerFactory();
    }

    @Bean
    public SmscConnectionFactoryBean senderClientFactoryBean(SmppProperties smppProperties, SmppResultGenerator smppResultGenerator, TypeOfAddressParser typeOfAddressParser, List<DeliveryReportConsumer> deliveryReportConsumers, ClientFactory clientFactory, ConnectionManagerFactory connectionManagerFactory) {
        return new SmscConnectionFactoryBean(smppProperties, smppResultGenerator, deliveryReportConsumers, typeOfAddressParser, clientFactory, connectionManagerFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={SmppResultGenerator.class})
    public SmppResultGenerator alwaysSuccessSmppResultGenerator() {
        return new AlwaysSuccessSmppResultGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={SenderManager.class})
    public SenderManager roundRobinSenderManager(SmscConnectionsHolder smscConnections) {
        return new StrategySenderManager(smscConnections.getConnections(), new RoundRobinIndexDetectionStrategy());
    }
}

