/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.config;

import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.reciever.ResponseClient;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import java.util.Optional;
import lombok.Generated;

public final class SmscConnection {
    private final String name;
    private final ResponseClient responseClient;
    private final SenderClient senderClient;

    public SmscConnection(String name, SenderClient senderClient) {
        this.name = name;
        this.senderClient = senderClient;
        this.responseClient = null;
    }

    public Optional<ResponseClient> getResponseClient() {
        return Optional.ofNullable(this.responseClient);
    }

    public void closeConnection() {
        this.senderClient.getConnectionManager().ifPresent(ConnectionManager::destroy);
        if (this.responseClient != null) {
            this.responseClient.destroyClient();
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SenderClient getSenderClient() {
        return this.senderClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmscConnection)) {
            return false;
        }
        SmscConnection other = (SmscConnection)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<ResponseClient> this$responseClient = this.getResponseClient();
        Optional<ResponseClient> other$responseClient = other.getResponseClient();
        if (this$responseClient == null ? other$responseClient != null : !((Object)this$responseClient).equals(other$responseClient)) {
            return false;
        }
        SenderClient this$senderClient = this.getSenderClient();
        SenderClient other$senderClient = other.getSenderClient();
        return !(this$senderClient == null ? other$senderClient != null : !this$senderClient.equals(other$senderClient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<ResponseClient> $responseClient = this.getResponseClient();
        result = result * 59 + ($responseClient == null ? 43 : ((Object)$responseClient).hashCode());
        SenderClient $senderClient = this.getSenderClient();
        result = result * 59 + ($senderClient == null ? 43 : $senderClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SmscConnection(name=" + this.getName() + ", responseClient=" + this.getResponseClient() + ", senderClient=" + this.getSenderClient() + ")";
    }

    @Generated
    public SmscConnection(String name, ResponseClient responseClient, SenderClient senderClient) {
        this.name = name;
        this.responseClient = responseClient;
        this.senderClient = senderClient;
    }
}

