/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.config;

import com.cloudhopper.smpp.SmppSessionHandler;
import com.github.mikesafonov.smpp.config.ConnectionMode;
import com.github.mikesafonov.smpp.config.ConnectionType;
import com.github.mikesafonov.smpp.config.SmppProperties;
import com.github.mikesafonov.smpp.config.SmscConnection;
import com.github.mikesafonov.smpp.config.SmscConnectionsHolder;
import com.github.mikesafonov.smpp.core.ClientFactory;
import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.connection.ConnectionManagerFactory;
import com.github.mikesafonov.smpp.core.generators.SmppResultGenerator;
import com.github.mikesafonov.smpp.core.reciever.DeliveryReportConsumer;
import com.github.mikesafonov.smpp.core.reciever.ResponseClient;
import com.github.mikesafonov.smpp.core.reciever.ResponseSmppSessionHandler;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import com.github.mikesafonov.smpp.core.sender.TypeOfAddressParser;
import com.github.mikesafonov.smpp.core.utils.Utils;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SmscConnectionFactoryBean
implements FactoryBean<SmscConnectionsHolder> {
    private final SmppProperties smppProperties;
    private final SmppResultGenerator smppResultGenerator;
    private final List<DeliveryReportConsumer> deliveryReportConsumers;
    private final TypeOfAddressParser typeOfAddressParser;
    private final ClientFactory clientFactory;
    private final ConnectionManagerFactory connectionManagerFactory;
    @Autowired(required=false)
    private SmppSessionHandler sessionHandler;

    public SmscConnectionsHolder getObject() {
        SmppProperties.Defaults defaults = this.smppProperties.getDefaults();
        List<SmscConnection> connections = this.smppProperties.getConnections().entrySet().stream().map(smsc -> this.getSmscConnection(defaults, (String)smsc.getKey(), (SmppProperties.SMSC)smsc.getValue())).collect(Collectors.toList());
        return new SmscConnectionsHolder(connections);
    }

    public Class<?> getObjectType() {
        return SmscConnectionsHolder.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private SmscConnection getSmscConnection(SmppProperties.Defaults defaults, String name, SmppProperties.SMSC smsc) {
        ConnectionMode connectionMode = Utils.getOrDefault(smsc.getConnectionMode(), defaults.getConnectionMode());
        switch (connectionMode) {
            case MOCK: {
                return this.getMockSmscConnection(name);
            }
            case TEST: {
                return this.getTestSmscConnection(defaults, name, smsc);
            }
            case STANDARD: {
                return this.getStandardSmscConnection(defaults, name, smsc);
            }
        }
        throw new RuntimeException("Unknown connection mode " + (Object)((Object)connectionMode));
    }

    private SmscConnection getMockSmscConnection(String name) {
        return new SmscConnection(name, this.clientFactory.mockSender(name, this.smppResultGenerator));
    }

    private SmscConnection getTestSmscConnection(SmppProperties.Defaults defaults, String name, SmppProperties.SMSC smsc) {
        SenderClient testSenderClient;
        ResponseClient responseClient = null;
        ConnectionType type = Utils.getOrDefault(smsc.getConnectionType(), defaults.getConnectionType());
        if (type == ConnectionType.TRANSCEIVER) {
            ConnectionManager transceiver = this.connectionManagerFactory.transceiver(name, defaults, smsc, this.getOrCreateHandler(name, this.deliveryReportConsumers));
            SenderClient standardSender = this.clientFactory.standardSender(name, defaults, smsc, this.typeOfAddressParser, transceiver);
            testSenderClient = this.clientFactory.testSender(standardSender, defaults, smsc, this.smppResultGenerator);
            if (this.isResponseClientRequired()) {
                responseClient = this.clientFactory.standardResponse(name, transceiver);
            }
        } else {
            ConnectionManager transmitter = this.connectionManagerFactory.transmitter(name, defaults, smsc);
            SenderClient standardSender = this.clientFactory.standardSender(name, defaults, smsc, this.typeOfAddressParser, transmitter);
            testSenderClient = this.clientFactory.testSender(standardSender, defaults, smsc, this.smppResultGenerator);
            if (this.isResponseClientRequired()) {
                ConnectionManager receiver = this.connectionManagerFactory.receiver(name, defaults, smsc, this.getOrCreateHandler(name, this.deliveryReportConsumers));
                responseClient = this.clientFactory.standardResponse(name, receiver);
            }
        }
        this.setupClients(testSenderClient, responseClient);
        return new SmscConnection(name, responseClient, testSenderClient);
    }

    private SmscConnection getStandardSmscConnection(SmppProperties.Defaults defaults, String name, SmppProperties.SMSC smsc) {
        SenderClient senderClient;
        ResponseClient responseClient = null;
        ConnectionType type = Utils.getOrDefault(smsc.getConnectionType(), defaults.getConnectionType());
        if (type == ConnectionType.TRANSCEIVER) {
            ConnectionManager connectionManager = this.connectionManagerFactory.transceiver(name, defaults, smsc, this.getOrCreateHandler(name, this.deliveryReportConsumers));
            senderClient = this.clientFactory.standardSender(name, defaults, smsc, this.typeOfAddressParser, connectionManager);
            if (this.isResponseClientRequired()) {
                responseClient = this.clientFactory.standardResponse(name, connectionManager);
            }
        } else {
            ConnectionManager transmitter = this.connectionManagerFactory.transmitter(name, defaults, smsc);
            senderClient = this.clientFactory.standardSender(name, defaults, smsc, this.typeOfAddressParser, transmitter);
            if (this.isResponseClientRequired()) {
                ConnectionManager receiver = this.connectionManagerFactory.receiver(name, defaults, smsc, this.getOrCreateHandler(name, this.deliveryReportConsumers));
                responseClient = this.clientFactory.standardResponse(name, receiver);
            }
        }
        this.setupClients(senderClient, responseClient);
        return new SmscConnection(name, responseClient, senderClient);
    }

    private void setupClients(SenderClient senderClient, ResponseClient responseClient) {
        if (this.smppProperties.isSetupRightAway()) {
            senderClient.setup();
            if (responseClient != null) {
                responseClient.setup();
            }
        }
    }

    private boolean isResponseClientRequired() {
        return !this.deliveryReportConsumers.isEmpty();
    }

    private SmppSessionHandler getOrCreateHandler(String name, List<DeliveryReportConsumer> deliveryReportConsumers) {
        if (this.sessionHandler == null) {
            return new ResponseSmppSessionHandler(name, deliveryReportConsumers);
        }
        return this.sessionHandler;
    }

    @Generated
    public SmscConnectionFactoryBean(SmppProperties smppProperties, SmppResultGenerator smppResultGenerator, List<DeliveryReportConsumer> deliveryReportConsumers, TypeOfAddressParser typeOfAddressParser, ClientFactory clientFactory, ConnectionManagerFactory connectionManagerFactory) {
        this.smppProperties = smppProperties;
        this.smppResultGenerator = smppResultGenerator;
        this.deliveryReportConsumers = deliveryReportConsumers;
        this.typeOfAddressParser = typeOfAddressParser;
        this.clientFactory = clientFactory;
        this.connectionManagerFactory = connectionManagerFactory;
    }

    @Generated
    public void setSessionHandler(SmppSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }
}

