/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core;

import com.github.mikesafonov.smpp.config.SmppProperties;
import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.generators.SmppResultGenerator;
import com.github.mikesafonov.smpp.core.reciever.ResponseClient;
import com.github.mikesafonov.smpp.core.reciever.StandardResponseClient;
import com.github.mikesafonov.smpp.core.sender.MessageBuilder;
import com.github.mikesafonov.smpp.core.sender.MockSenderClient;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import com.github.mikesafonov.smpp.core.sender.StandardSenderClient;
import com.github.mikesafonov.smpp.core.sender.TestSenderClient;
import com.github.mikesafonov.smpp.core.sender.TypeOfAddressParser;
import com.github.mikesafonov.smpp.core.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class ClientFactory {
    public SenderClient mockSender(@NotBlank String name, @NotNull SmppResultGenerator smppResultGenerator) {
        Utils.validateName(name);
        Objects.requireNonNull(smppResultGenerator);
        return new MockSenderClient(smppResultGenerator, name);
    }

    public SenderClient testSender(@NotNull SenderClient senderClient, @NotNull SmppProperties.Defaults defaults, @NotNull SmppProperties.SMSC smsc, @NotNull SmppResultGenerator smppResultGenerator) {
        Objects.requireNonNull(senderClient);
        Objects.requireNonNull(defaults);
        Objects.requireNonNull(smppResultGenerator);
        Objects.requireNonNull(smsc);
        String[] phones = Utils.getOrDefault(smsc.getAllowedPhones(), defaults.getAllowedPhones());
        List<String> allowedPhones = phones == null ? Collections.emptyList() : Arrays.asList(phones);
        return new TestSenderClient(senderClient, allowedPhones, smppResultGenerator);
    }

    public SenderClient standardSender(@NotBlank String name, @NotNull SmppProperties.Defaults defaults, @NotNull SmppProperties.SMSC smsc, @NotNull TypeOfAddressParser typeOfAddressParser, @NotNull ConnectionManager connectionManager) {
        Utils.validateName(name);
        Objects.requireNonNull(defaults);
        Objects.requireNonNull(smsc);
        Objects.requireNonNull(typeOfAddressParser);
        Objects.requireNonNull(connectionManager);
        boolean ucs2Only = Utils.getOrDefault(smsc.getUcs2Only(), defaults.isUcs2Only());
        long requestTimeout = Utils.getOrDefault(smsc.getRequestTimeout(), defaults.getRequestTimeout()).toMillis();
        return new StandardSenderClient(connectionManager, ucs2Only, requestTimeout, new MessageBuilder(typeOfAddressParser));
    }

    public ResponseClient standardResponse(@NotBlank String name, @NotNull ConnectionManager connectionManager) {
        Utils.validateName(name);
        Objects.requireNonNull(connectionManager);
        return new StandardResponseClient(connectionManager);
    }
}

