/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.connection;

import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.github.mikesafonov.smpp.core.connection.BaseSmppSessionConfiguration;
import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.exceptions.SmppSessionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSenderConnectionManager
implements ConnectionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseSenderConnectionManager.class);
    private static final String SENDER_SUCCESS_BINDED_MESSAGE = "SENDER SUCCESSFUL BINDED";
    protected final DefaultSmppClient client;
    protected final BaseSmppSessionConfiguration configuration;
    protected final SmppSessionHandler sessionHandler;
    protected final int maxTryCount;
    protected SmppSession session;

    public BaseSenderConnectionManager(DefaultSmppClient client, BaseSmppSessionConfiguration configuration, int maxTryCount) {
        this.client = client;
        this.configuration = configuration;
        this.maxTryCount = maxTryCount;
        this.sessionHandler = null;
    }

    @Override
    public SmppSession getSession() {
        this.checkSession();
        return this.session;
    }

    @Override
    public void closeSession() {
        if (this.session != null) {
            this.session.close();
            this.session.destroy();
            this.session = null;
        }
    }

    @Override
    public BaseSmppSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void destroy() {
        this.closeSession();
        this.client.destroy();
    }

    private void checkSession() {
        boolean connectionAlive = false;
        for (int tryCount = 0; !connectionAlive && tryCount < this.maxTryCount; ++tryCount) {
            if (this.session == null) {
                connectionAlive = this.bind();
                continue;
            }
            log.debug("Session state is " + this.session.getStateName() + " bound: " + this.session.isBound());
            connectionAlive = this.checkBoundState();
        }
        if (!connectionAlive) {
            throw new SmppSessionException();
        }
    }

    protected boolean bind() {
        try {
            this.session = this.client.bind((SmppSessionConfiguration)this.configuration, this.sessionHandler);
            log.debug(SENDER_SUCCESS_BINDED_MESSAGE);
            return true;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean checkBoundState() {
        if (this.session.isBound()) {
            return this.pingOrReconnect();
        }
        return this.isBindingOrReconnect();
    }

    private boolean isBindingOrReconnect() {
        if (this.session.isBinding()) {
            this.sleep(50L);
            return false;
        }
        return this.reconnect();
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean pingOrReconnect() {
        return this.pingConnection() || this.reconnect();
    }

    private boolean pingConnection() {
        try {
            this.session.enquireLink(new EnquireLink(), 1000L);
            return true;
        }
        catch (Exception ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean reconnect() {
        this.closeSession();
        return this.bind();
    }

    @Generated
    public BaseSenderConnectionManager(DefaultSmppClient client, BaseSmppSessionConfiguration configuration, SmppSessionHandler sessionHandler, int maxTryCount) {
        this.client = client;
        this.configuration = configuration;
        this.sessionHandler = sessionHandler;
        this.maxTryCount = maxTryCount;
    }
}

