/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.connection;

import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.github.mikesafonov.smpp.config.SmppProperties;
import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.connection.ReceiverConfiguration;
import com.github.mikesafonov.smpp.core.connection.ReceiverConnectionManager;
import com.github.mikesafonov.smpp.core.connection.TransceiverConfiguration;
import com.github.mikesafonov.smpp.core.connection.TransceiverConnectionManager;
import com.github.mikesafonov.smpp.core.connection.TransmitterConfiguration;
import com.github.mikesafonov.smpp.core.connection.TransmitterConnectionManager;
import com.github.mikesafonov.smpp.core.utils.Utils;
import java.util.Objects;
import java.util.concurrent.Executors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.lang.Nullable;

public class ConnectionManagerFactory {
    public ConnectionManager transmitter(@NotBlank String name, @NotNull SmppProperties.Defaults defaults, @NotNull SmppProperties.SMSC smsc) {
        Utils.validateName(name);
        Objects.requireNonNull(defaults);
        Objects.requireNonNull(smsc);
        boolean loggingBytes = Utils.getOrDefault(smsc.getLoggingBytes(), defaults.isLoggingBytes());
        boolean loggingPdu = Utils.getOrDefault(smsc.getLoggingPdu(), defaults.isLoggingPdu());
        int windowsSize = Utils.getOrDefault(smsc.getWindowSize(), defaults.getWindowSize());
        int maxTry = Utils.getOrDefault(smsc.getMaxTry(), defaults.getMaxTry());
        TransmitterConfiguration transmitterConfiguration = new TransmitterConfiguration(name, smsc.getCredentials(), loggingBytes, loggingPdu, windowsSize, smsc.getSystemType());
        DefaultSmppClient client = new DefaultSmppClient();
        return new TransmitterConnectionManager(client, transmitterConfiguration, maxTry);
    }

    public ConnectionManager receiver(@NotBlank String name, @NotNull SmppProperties.Defaults defaults, @NotNull SmppProperties.SMSC smsc, @Nullable SmppSessionHandler smppSessionHandler) {
        Utils.validateName(name);
        Objects.requireNonNull(defaults);
        Objects.requireNonNull(smsc);
        boolean loggingBytes = Utils.getOrDefault(smsc.getLoggingBytes(), defaults.isLoggingBytes());
        boolean loggingPdu = Utils.getOrDefault(smsc.getLoggingPdu(), defaults.isLoggingPdu());
        long rebindPeriod = Utils.getOrDefault(smsc.getRebindPeriod(), defaults.getRebindPeriod()).getSeconds();
        ReceiverConfiguration receiverConfiguration = new ReceiverConfiguration(name, smsc.getCredentials(), loggingBytes, loggingPdu);
        DefaultSmppClient client = new DefaultSmppClient();
        return new ReceiverConnectionManager(client, receiverConfiguration, smppSessionHandler, rebindPeriod, Executors.newSingleThreadScheduledExecutor());
    }

    public ConnectionManager transceiver(@NotBlank String name, @NotNull SmppProperties.Defaults defaults, @NotNull SmppProperties.SMSC smsc, @Nullable SmppSessionHandler smppSessionHandler) {
        Utils.validateName(name);
        Objects.requireNonNull(defaults);
        Objects.requireNonNull(smsc);
        boolean loggingBytes = Utils.getOrDefault(smsc.getLoggingBytes(), defaults.isLoggingBytes());
        boolean loggingPdu = Utils.getOrDefault(smsc.getLoggingPdu(), defaults.isLoggingPdu());
        int windowsSize = Utils.getOrDefault(smsc.getWindowSize(), defaults.getWindowSize());
        int maxTry = Utils.getOrDefault(smsc.getMaxTry(), defaults.getMaxTry());
        TransceiverConfiguration configuration = new TransceiverConfiguration(name, smsc.getCredentials(), loggingBytes, loggingPdu, windowsSize, smsc.getSystemType());
        DefaultSmppClient client = new DefaultSmppClient();
        return new TransceiverConnectionManager(client, configuration, smppSessionHandler, maxTry);
    }
}

