/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.connection;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.type.LoggingOptions;
import com.github.mikesafonov.smpp.config.SmppProperties;
import com.github.mikesafonov.smpp.core.connection.BaseSmppSessionConfiguration;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class ReceiverConfiguration
extends BaseSmppSessionConfiguration {
    public ReceiverConfiguration(@NotNull String name, @NotNull SmppProperties.Credentials credentials, boolean loggingBytes, boolean loggingPdu) {
        this.setType(SmppBindType.RECEIVER);
        this.setName(Objects.requireNonNull(name));
        this.setHost(credentials.getHost());
        this.setPort(credentials.getPort());
        this.setSystemId(credentials.getUsername());
        this.setPassword(credentials.getPassword());
        LoggingOptions loggingOptions = new LoggingOptions();
        loggingOptions.setLogBytes(loggingBytes);
        loggingOptions.setLogPdu(loggingPdu);
        this.setLoggingOptions(loggingOptions);
    }

    @Override
    public String configInformation() {
        return String.format("%s host=%s port=%d username=%s", this.getName(), this.getHost(), this.getPort(), this.getSystemId());
    }
}

