/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.connection;

import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.github.mikesafonov.smpp.core.connection.BaseSmppSessionConfiguration;
import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.connection.ReceiverConfiguration;
import com.github.mikesafonov.smpp.core.connection.ResponseClientRebindTask;
import com.github.mikesafonov.smpp.core.exceptions.ResponseClientBindException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverConnectionManager
implements ConnectionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReceiverConnectionManager.class);
    private static final String SESSION_SUCCESS_MESSAGE = "SESSION SUCCESSFUL REBINDED";
    private final DefaultSmppClient client;
    private final ReceiverConfiguration configuration;
    private final SmppSessionHandler sessionHandler;
    private final long rebindPeriod;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> rebindTask;
    private SmppSession session;

    @Override
    public SmppSession getSession() {
        this.checkSession();
        return this.session;
    }

    @Override
    public void closeSession() {
        if (this.session != null) {
            this.session.close();
            this.session.destroy();
            this.session = null;
        }
    }

    @Override
    public BaseSmppSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void destroy() {
        this.interruptIfNotNull();
        this.scheduledExecutorService.shutdown();
        this.closeSession();
        this.client.destroy();
    }

    private void checkSession() {
        if (this.session == null) {
            this.bind();
        }
        if (this.session == null) {
            throw new ResponseClientBindException(String.format("Unable to bind with configuration: %s ", this.configuration.configInformation()));
        }
        this.setupRebindTask();
    }

    private void bind() {
        try {
            this.session = this.client.bind((SmppSessionConfiguration)this.configuration, this.sessionHandler);
            log.debug(SESSION_SUCCESS_MESSAGE);
        }
        catch (SmppChannelException | SmppTimeoutException | UnrecoverablePduException | InterruptedException ex) {
            log.error(ex.getMessage(), ex);
            this.session = null;
        }
    }

    private void reconnect() {
        this.closeSession();
        this.bind();
    }

    private void setupRebindTask() {
        this.interruptIfNotNull();
        this.rebindTask = this.scheduledExecutorService.scheduleAtFixedRate(new ResponseClientRebindTask(this.session, this::reconnect), 5L, this.rebindPeriod, TimeUnit.SECONDS);
    }

    private void interruptIfNotNull() {
        if (this.rebindTask != null) {
            this.rebindTask.cancel(true);
        }
    }

    @Generated
    public ReceiverConnectionManager(DefaultSmppClient client, ReceiverConfiguration configuration, SmppSessionHandler sessionHandler, long rebindPeriod, ScheduledExecutorService scheduledExecutorService) {
        this.client = client;
        this.configuration = configuration;
        this.sessionHandler = sessionHandler;
        this.rebindPeriod = rebindPeriod;
        this.scheduledExecutorService = scheduledExecutorService;
    }
}

