/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.connection;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.type.LoggingOptions;
import com.github.mikesafonov.smpp.config.SmppProperties;
import com.github.mikesafonov.smpp.core.connection.BaseSmppSessionConfiguration;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class TransmitterConfiguration
extends BaseSmppSessionConfiguration {
    public TransmitterConfiguration(@NotNull String name, @NotNull SmppProperties.Credentials credentials, boolean loggingBytes, boolean loggingPdu, int windowsSize, String systemType) {
        this.setType(SmppBindType.TRANSMITTER);
        this.setName(Objects.requireNonNull(name));
        this.setHost(credentials.getHost());
        this.setPort(credentials.getPort());
        this.setSystemId(credentials.getUsername());
        this.setPassword(credentials.getPassword());
        this.setWindowSize(windowsSize);
        this.setSystemType(systemType);
        LoggingOptions loggingOptions = new LoggingOptions();
        loggingOptions.setLogBytes(loggingBytes);
        loggingOptions.setLogPdu(loggingPdu);
        this.setLoggingOptions(loggingOptions);
    }

    @Override
    public String configInformation() {
        return String.format("%s host=%s port=%d username=%s windowsSize=%d", this.getName(), this.getHost(), this.getPort(), this.getSystemId(), this.getWindowSize());
    }
}

