/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.dto;

import com.cloudhopper.smpp.util.DeliveryReceipt;
import com.github.mikesafonov.smpp.core.utils.JodaJavaConverter;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class DeliveryReport {
    private String messageId;
    private ZonedDateTime deliveryDate;
    private ZonedDateTime submitDate;
    private int deliveredCount;
    private int submitCount;
    private int errorCode;
    private int state;
    private String responseClientId;
    private String text;

    public static DeliveryReport of(@NotNull DeliveryReceipt deliveryReceipt, @NotNull String responseClientId) {
        DeliveryReport deliveryReport = new DeliveryReport();
        deliveryReport.setDeliveredCount(deliveryReceipt.getDeliveredCount());
        deliveryReport.setMessageId(deliveryReceipt.getMessageId());
        deliveryReport.setErrorCode(deliveryReceipt.getErrorCode());
        deliveryReport.setState(deliveryReceipt.getState());
        deliveryReport.setSubmitCount(deliveryReceipt.getSubmitCount());
        deliveryReport.setDeliveryDate(JodaJavaConverter.convert(deliveryReceipt.getDoneDate()));
        deliveryReport.setSubmitDate(JodaJavaConverter.convert(deliveryReceipt.getSubmitDate()));
        deliveryReport.setResponseClientId(responseClientId);
        deliveryReport.setText(deliveryReceipt.getText());
        return deliveryReport;
    }

    @Generated
    public DeliveryReport() {
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public ZonedDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    @Generated
    public ZonedDateTime getSubmitDate() {
        return this.submitDate;
    }

    @Generated
    public int getDeliveredCount() {
        return this.deliveredCount;
    }

    @Generated
    public int getSubmitCount() {
        return this.submitCount;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public int getState() {
        return this.state;
    }

    @Generated
    public String getResponseClientId() {
        return this.responseClientId;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setDeliveryDate(ZonedDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    @Generated
    public void setSubmitDate(ZonedDateTime submitDate) {
        this.submitDate = submitDate;
    }

    @Generated
    public void setDeliveredCount(int deliveredCount) {
        this.deliveredCount = deliveredCount;
    }

    @Generated
    public void setSubmitCount(int submitCount) {
        this.submitCount = submitCount;
    }

    @Generated
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setState(int state) {
        this.state = state;
    }

    @Generated
    public void setResponseClientId(String responseClientId) {
        this.responseClientId = responseClientId;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeliveryReport)) {
            return false;
        }
        DeliveryReport other = (DeliveryReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDeliveredCount() != other.getDeliveredCount()) {
            return false;
        }
        if (this.getSubmitCount() != other.getSubmitCount()) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        ZonedDateTime this$deliveryDate = this.getDeliveryDate();
        ZonedDateTime other$deliveryDate = other.getDeliveryDate();
        if (this$deliveryDate == null ? other$deliveryDate != null : !((Object)this$deliveryDate).equals(other$deliveryDate)) {
            return false;
        }
        ZonedDateTime this$submitDate = this.getSubmitDate();
        ZonedDateTime other$submitDate = other.getSubmitDate();
        if (this$submitDate == null ? other$submitDate != null : !((Object)this$submitDate).equals(other$submitDate)) {
            return false;
        }
        String this$responseClientId = this.getResponseClientId();
        String other$responseClientId = other.getResponseClientId();
        if (this$responseClientId == null ? other$responseClientId != null : !this$responseClientId.equals(other$responseClientId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeliveryReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDeliveredCount();
        result = result * 59 + this.getSubmitCount();
        result = result * 59 + this.getErrorCode();
        result = result * 59 + this.getState();
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        ZonedDateTime $deliveryDate = this.getDeliveryDate();
        result = result * 59 + ($deliveryDate == null ? 43 : ((Object)$deliveryDate).hashCode());
        ZonedDateTime $submitDate = this.getSubmitDate();
        result = result * 59 + ($submitDate == null ? 43 : ((Object)$submitDate).hashCode());
        String $responseClientId = this.getResponseClientId();
        result = result * 59 + ($responseClientId == null ? 43 : $responseClientId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeliveryReport(messageId=" + this.getMessageId() + ", deliveryDate=" + this.getDeliveryDate() + ", submitDate=" + this.getSubmitDate() + ", deliveredCount=" + this.getDeliveredCount() + ", submitCount=" + this.getSubmitCount() + ", errorCode=" + this.getErrorCode() + ", state=" + this.getState() + ", responseClientId=" + this.getResponseClientId() + ", text=" + this.getText() + ")";
    }
}

