/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.dto;

import com.github.mikesafonov.smpp.core.dto.MessageType;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class Message {
    @NotBlank
    private String text;
    @NotBlank
    private String msisdn;
    @NotBlank
    private String source;
    @Nullable
    private String messageId;
    @NotNull
    private MessageType messageType;
    @Nullable
    private String validityPeriod;

    public Message(@NotBlank String text, @NotBlank String msisdn, @NotBlank String source, @Nullable String messageId, @NotNull MessageType messageType) {
        this.text = text;
        this.msisdn = msisdn;
        this.source = source;
        this.messageId = messageId;
        this.messageType = messageType;
    }

    public boolean isSilent() {
        return this.messageType == MessageType.SILENT;
    }

    public static MessageBuilder silent(String text) {
        return new MessageBuilder(text, MessageType.SILENT);
    }

    public static MessageBuilder datagram(String text) {
        return new MessageBuilder(text, MessageType.DATAGRAM);
    }

    public static MessageBuilder simple(String text) {
        return new MessageBuilder(text, MessageType.SIMPLE);
    }

    public static MessageBuilder flash(String text) {
        return new MessageBuilder(text, MessageType.FLASH);
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getMsisdn() {
        return this.msisdn;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Nullable
    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Nullable
    @Generated
    public String getValidityPeriod() {
        return this.validityPeriod;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setMessageId(@Nullable String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Generated
    public void setValidityPeriod(@Nullable String validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$validityPeriod = this.getValidityPeriod();
        String other$validityPeriod = other.getValidityPeriod();
        return !(this$validityPeriod == null ? other$validityPeriod != null : !this$validityPeriod.equals(other$validityPeriod));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $validityPeriod = this.getValidityPeriod();
        result = result * 59 + ($validityPeriod == null ? 43 : $validityPeriod.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Message(text=" + this.getText() + ", msisdn=" + this.getMsisdn() + ", source=" + this.getSource() + ", messageId=" + this.getMessageId() + ", messageType=" + (Object)((Object)this.getMessageType()) + ", validityPeriod=" + this.getValidityPeriod() + ")";
    }

    @Generated
    public Message(String text, String msisdn, String source, @Nullable String messageId, MessageType messageType, @Nullable String validityPeriod) {
        this.text = text;
        this.msisdn = msisdn;
        this.source = source;
        this.messageId = messageId;
        this.messageType = messageType;
        this.validityPeriod = validityPeriod;
    }

    public static class MessageBuilder {
        private final String text;
        private final MessageType messageType;
        private String msisdn;
        private String source;
        private String messageId;
        private String validityPeriod;

        public MessageBuilder(String text, MessageType messageType) {
            this.text = text;
            this.messageType = messageType;
        }

        public MessageBuilder from(String from) {
            this.source = from;
            return this;
        }

        public MessageBuilder to(String to) {
            this.msisdn = to;
            return this;
        }

        public MessageBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public MessageBuilder validityPeriod(String validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Message build() {
            return new Message(this.text, this.msisdn, this.source, this.messageId, this.messageType, this.validityPeriod);
        }
    }
}

