/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.dto;

import com.github.mikesafonov.smpp.core.dto.Message;
import com.github.mikesafonov.smpp.core.dto.MessageErrorInformation;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.lang.Nullable;

public final class MessageResponse {
    @NotNull
    private final Message original;
    @NotBlank
    private final String smscId;
    @Nullable
    private final String smscMessageID;
    private final boolean sent;
    @Nullable
    private final MessageErrorInformation messageErrorInformation;

    public static MessageResponse success(@NotNull Message original, @NotBlank String smscId, String smscMessageID) {
        return new MessageResponse(original, smscId, smscMessageID, true, null);
    }

    public static MessageResponse error(@NotNull Message original, @NotBlank String smscId, @NotNull MessageErrorInformation messageErrorInformation) {
        return new MessageResponse(original, smscId, null, false, messageErrorInformation);
    }

    public boolean isSuccess() {
        return this.messageErrorInformation == null;
    }

    public boolean isError() {
        return this.messageErrorInformation != null;
    }

    @Generated
    public MessageResponse(Message original, String smscId, @Nullable String smscMessageID, boolean sent, @Nullable MessageErrorInformation messageErrorInformation) {
        this.original = original;
        this.smscId = smscId;
        this.smscMessageID = smscMessageID;
        this.sent = sent;
        this.messageErrorInformation = messageErrorInformation;
    }

    @Generated
    public Message getOriginal() {
        return this.original;
    }

    @Generated
    public String getSmscId() {
        return this.smscId;
    }

    @Nullable
    @Generated
    public String getSmscMessageID() {
        return this.smscMessageID;
    }

    @Generated
    public boolean isSent() {
        return this.sent;
    }

    @Nullable
    @Generated
    public MessageErrorInformation getMessageErrorInformation() {
        return this.messageErrorInformation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageResponse)) {
            return false;
        }
        MessageResponse other = (MessageResponse)o;
        if (this.isSent() != other.isSent()) {
            return false;
        }
        Message this$original = this.getOriginal();
        Message other$original = other.getOriginal();
        if (this$original == null ? other$original != null : !((Object)this$original).equals(other$original)) {
            return false;
        }
        String this$smscId = this.getSmscId();
        String other$smscId = other.getSmscId();
        if (this$smscId == null ? other$smscId != null : !this$smscId.equals(other$smscId)) {
            return false;
        }
        String this$smscMessageID = this.getSmscMessageID();
        String other$smscMessageID = other.getSmscMessageID();
        if (this$smscMessageID == null ? other$smscMessageID != null : !this$smscMessageID.equals(other$smscMessageID)) {
            return false;
        }
        MessageErrorInformation this$messageErrorInformation = this.getMessageErrorInformation();
        MessageErrorInformation other$messageErrorInformation = other.getMessageErrorInformation();
        return !(this$messageErrorInformation == null ? other$messageErrorInformation != null : !((Object)this$messageErrorInformation).equals(other$messageErrorInformation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSent() ? 79 : 97);
        Message $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : ((Object)$original).hashCode());
        String $smscId = this.getSmscId();
        result = result * 59 + ($smscId == null ? 43 : $smscId.hashCode());
        String $smscMessageID = this.getSmscMessageID();
        result = result * 59 + ($smscMessageID == null ? 43 : $smscMessageID.hashCode());
        MessageErrorInformation $messageErrorInformation = this.getMessageErrorInformation();
        result = result * 59 + ($messageErrorInformation == null ? 43 : ((Object)$messageErrorInformation).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageResponse(original=" + this.getOriginal() + ", smscId=" + this.getSmscId() + ", smscMessageID=" + this.getSmscMessageID() + ", sent=" + this.isSent() + ", messageErrorInformation=" + this.getMessageErrorInformation() + ")";
    }
}

