/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.reciever;

import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.util.DeliveryReceipt;
import com.cloudhopper.smpp.util.DeliveryReceiptException;
import com.github.mikesafonov.smpp.core.dto.DeliveryReport;
import com.github.mikesafonov.smpp.core.reciever.DeliveryReportConsumer;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseSmppSessionHandler
extends DefaultSmppSessionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseSmppSessionHandler.class);
    private final String clientId;
    private final List<DeliveryReportConsumer> deliveryReportConsumers;

    public ResponseSmppSessionHandler(String clientId, @NotNull List<DeliveryReportConsumer> deliveryReportConsumers) {
        this.clientId = Objects.requireNonNull(clientId);
        this.deliveryReportConsumers = Objects.requireNonNull(deliveryReportConsumers);
    }

    public PduResponse firePduRequestReceived(PduRequest pduRequest) {
        log.debug(pduRequest.toString());
        if (this.isDelivery(pduRequest)) {
            this.processReport(pduRequest);
        }
        return pduRequest.createResponse();
    }

    private boolean isDelivery(PduRequest pduRequest) {
        return pduRequest.isRequest() && pduRequest.getClass() == DeliverSm.class;
    }

    private void processReport(PduRequest pduRequest) {
        DeliverSm dlr = (DeliverSm)pduRequest;
        try {
            DeliveryReport report = this.toReport(dlr);
            for (DeliveryReportConsumer deliveryReportConsumer : this.deliveryReportConsumers) {
                deliveryReportConsumer.accept(report);
            }
        }
        catch (DeliveryReceiptException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private DeliveryReport toReport(DeliverSm deliverSm) throws DeliveryReceiptException {
        byte[] shortMessage = deliverSm.getShortMessage();
        String sms = new String(shortMessage);
        DeliveryReceipt deliveryReceipt = DeliveryReceipt.parseShortMessage((String)sms, (DateTimeZone)DateTimeZone.UTC);
        return DeliveryReport.of(deliveryReceipt, this.clientId);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseSmppSessionHandler)) {
            return false;
        }
        ResponseSmppSessionHandler other = (ResponseSmppSessionHandler)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clientId = this.clientId;
        String other$clientId = other.clientId;
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        List<DeliveryReportConsumer> this$deliveryReportConsumers = this.deliveryReportConsumers;
        List<DeliveryReportConsumer> other$deliveryReportConsumers = other.deliveryReportConsumers;
        return !(this$deliveryReportConsumers == null ? other$deliveryReportConsumers != null : !((Object)this$deliveryReportConsumers).equals(other$deliveryReportConsumers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseSmppSessionHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clientId = this.clientId;
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        List<DeliveryReportConsumer> $deliveryReportConsumers = this.deliveryReportConsumers;
        result = result * 59 + ($deliveryReportConsumers == null ? 43 : ((Object)$deliveryReportConsumers).hashCode());
        return result;
    }
}

