/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.cloudhopper.commons.gsm.TypeOfAddress;
import com.cloudhopper.smpp.type.Address;
import com.github.mikesafonov.smpp.core.sender.TypeOfAddressParser;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class AddressBuilder {
    private final TypeOfAddressParser addressParser;

    public AddressBuilder(@NotNull TypeOfAddressParser addressParser) {
        this.addressParser = Objects.requireNonNull(addressParser);
    }

    @NotNull
    public Address createSourceAddress(@NotNull String source) {
        return this.convertToAddress(source, this.addressParser.getSource(source));
    }

    @NotNull
    public Address createDestinationAddress(@NotNull String msisdn) {
        return this.convertToAddress(msisdn, this.addressParser.getDestination(msisdn));
    }

    private Address convertToAddress(String value, TypeOfAddress typeOfAddress) {
        byte ton = (byte)typeOfAddress.getTon().toInt();
        byte npi = (byte)typeOfAddress.getNpi().toInt();
        return new Address(ton, npi, value);
    }
}

