/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.cloudhopper.commons.gsm.Npi;
import com.cloudhopper.commons.gsm.Ton;
import com.cloudhopper.commons.gsm.TypeOfAddress;
import com.github.mikesafonov.smpp.core.exceptions.IllegalAddressException;
import com.github.mikesafonov.smpp.core.sender.TypeOfAddressParser;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeOfAddressParser
implements TypeOfAddressParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTypeOfAddressParser.class);
    private static final Pattern ALPHABET_PATTERN = Pattern.compile("^[a-zA-Z0-9_ -]{3,11}$");
    private static final Pattern INTERNATIONAL_PATTERN = Pattern.compile("^[0-9]{10,15}$");

    @Override
    @NotNull
    public TypeOfAddress getSource(@NotNull String source) {
        try {
            if (this.checkPattern(source, INTERNATIONAL_PATTERN)) {
                return new TypeOfAddress(Ton.INTERNATIONAL, Npi.ISDN);
            }
            if (this.checkPattern(source, ALPHABET_PATTERN)) {
                return new TypeOfAddress(Ton.ALPHANUMERIC, Npi.UNKNOWN);
            }
            return new TypeOfAddress(Ton.UNKNOWN, Npi.UNKNOWN);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalAddressException(String.format("Source %s not supported", source));
        }
    }

    @Override
    @NotNull
    public TypeOfAddress getDestination(@NotNull String destination) {
        try {
            if (this.checkPattern(destination, INTERNATIONAL_PATTERN)) {
                return new TypeOfAddress(Ton.INTERNATIONAL, Npi.ISDN);
            }
            return new TypeOfAddress(Ton.UNKNOWN, Npi.UNKNOWN);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalAddressException(String.format("Destination %s not supported", destination));
        }
    }

    private boolean checkPattern(@NotNull String source, @NotNull Pattern pattern) {
        return pattern.matcher(source).matches();
    }
}

