/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.cloudhopper.smpp.pdu.CancelSm;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.type.Address;
import com.github.mikesafonov.smpp.core.dto.CancelMessage;
import com.github.mikesafonov.smpp.core.dto.Message;
import com.github.mikesafonov.smpp.core.dto.MessageType;
import com.github.mikesafonov.smpp.core.exceptions.SmppMessageBuildingException;
import com.github.mikesafonov.smpp.core.sender.AddressBuilder;
import com.github.mikesafonov.smpp.core.sender.SubmitSmEncoderFactory;
import com.github.mikesafonov.smpp.core.sender.TypeOfAddressParser;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageBuilder.class);
    private final AddressBuilder addressBuilder;
    private final SubmitSmEncoderFactory encoderFactory;

    public MessageBuilder(@NotNull TypeOfAddressParser typeOfAddressParser) {
        this(new AddressBuilder(typeOfAddressParser), new SubmitSmEncoderFactory());
    }

    public MessageBuilder(@NotNull AddressBuilder addressBuilder, @NotNull SubmitSmEncoderFactory encoderFactory) {
        this.addressBuilder = addressBuilder;
        this.encoderFactory = encoderFactory;
    }

    @NotNull
    public SubmitSm createSubmitSm(@NotNull Message message, boolean ucs2Only) {
        try {
            Address sourceAddress = this.addressBuilder.createSourceAddress(message.getSource());
            Address destAddress = this.addressBuilder.createDestinationAddress(message.getMsisdn());
            return this.createSubmitSm(message, sourceAddress, destAddress, ucs2Only);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SmppMessageBuildingException();
        }
    }

    public CancelSm createCancelSm(CancelMessage cancelMessage) {
        Address sourceAddress = this.addressBuilder.createSourceAddress(cancelMessage.getSource());
        Address destAddress = this.addressBuilder.createDestinationAddress(cancelMessage.getMsisdn());
        CancelSm cancelSm = new CancelSm();
        cancelSm.setSourceAddress(sourceAddress);
        cancelSm.setDestAddress(destAddress);
        cancelSm.setMessageId(cancelMessage.getMessageId());
        return cancelSm;
    }

    private byte getEsmClass(MessageType messageType) {
        if (messageType == MessageType.DATAGRAM) {
            return 1;
        }
        if (messageType == MessageType.FLASH) {
            return 0;
        }
        return 3;
    }

    @NotNull
    private SubmitSm createSubmitSm(@NotNull Message message, @NotNull Address sourceAddress, @NotNull Address destAddress, boolean ucs2Only) {
        byte esmClass = this.getEsmClass(message.getMessageType());
        SubmitSm sm = new SubmitSm();
        sm.setEsmClass(esmClass);
        sm.setSourceAddress(sourceAddress);
        sm.setDestAddress(destAddress);
        sm.setValidityPeriod(message.getValidityPeriod());
        this.encoderFactory.get(message).encode(message, sm, ucs2Only);
        if (message.getMessageType() == MessageType.SIMPLE) {
            sm.setRegisteredDelivery((byte)1);
        }
        return sm;
    }
}

