/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.dto.CancelMessage;
import com.github.mikesafonov.smpp.core.dto.CancelMessageResponse;
import com.github.mikesafonov.smpp.core.dto.Message;
import com.github.mikesafonov.smpp.core.dto.MessageResponse;
import com.github.mikesafonov.smpp.core.generators.SmppResultGenerator;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class MockSenderClient
implements SenderClient {
    private final SmppResultGenerator smppResultGenerator;
    private final String id;

    public MockSenderClient(@NotNull SmppResultGenerator smppResultGenerator, @NotNull String id) {
        this.smppResultGenerator = Objects.requireNonNull(smppResultGenerator);
        this.id = Objects.requireNonNull(id);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void setup() {
    }

    @Override
    @NotNull
    public MessageResponse send(@NotNull Message message) {
        return this.smppResultGenerator.generate(this.id, message);
    }

    @Override
    @NotNull
    public CancelMessageResponse cancel(@NotNull CancelMessage cancelMessage) {
        return this.smppResultGenerator.generate(this.id, cancelMessage);
    }

    @Override
    public Optional<ConnectionManager> getConnectionManager() {
        return Optional.empty();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockSenderClient)) {
            return false;
        }
        MockSenderClient other = (MockSenderClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SmppResultGenerator this$smppResultGenerator = this.smppResultGenerator;
        SmppResultGenerator other$smppResultGenerator = other.smppResultGenerator;
        if (this$smppResultGenerator == null ? other$smppResultGenerator != null : !this$smppResultGenerator.equals(other$smppResultGenerator)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockSenderClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SmppResultGenerator $smppResultGenerator = this.smppResultGenerator;
        result = result * 59 + ($smppResultGenerator == null ? 43 : $smppResultGenerator.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

