/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.tlv.Tlv;
import com.github.mikesafonov.smpp.core.dto.Message;
import com.github.mikesafonov.smpp.core.sender.SubmitSmEncoder;
import com.github.mikesafonov.smpp.core.utils.CountWithEncoding;
import com.github.mikesafonov.smpp.core.utils.MessageUtil;
import javax.validation.constraints.NotNull;

public class SimpleSubmitSmEncoder
implements SubmitSmEncoder {
    @Override
    public void encode(Message message, SubmitSm submitSm, boolean ucs2Only) {
        CountWithEncoding countWithEncoding = MessageUtil.calculateCountSMS(message.getText(), ucs2Only);
        byte coding = this.findCoding(countWithEncoding.getCharset());
        submitSm.setDataCoding(coding);
        byte[] messageByte = CharsetUtil.encode((CharSequence)message.getText(), (Charset)countWithEncoding.getCharset());
        if (countWithEncoding.getCount() > 1) {
            submitSm.setShortMessage(new byte[0]);
            submitSm.addOptionalParameter(new Tlv(1060, messageByte));
        } else {
            submitSm.setShortMessage(messageByte);
        }
    }

    private byte findCoding(@NotNull Charset charset) {
        return charset == CharsetUtil.CHARSET_GSM ? (byte)0 : 8;
    }
}

