/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.pdu.CancelSm;
import com.cloudhopper.smpp.pdu.CancelSmResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppInvalidArgumentException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.dto.CancelMessage;
import com.github.mikesafonov.smpp.core.dto.CancelMessageResponse;
import com.github.mikesafonov.smpp.core.dto.Message;
import com.github.mikesafonov.smpp.core.dto.MessageErrorInformation;
import com.github.mikesafonov.smpp.core.dto.MessageResponse;
import com.github.mikesafonov.smpp.core.exceptions.IllegalAddressException;
import com.github.mikesafonov.smpp.core.exceptions.SenderClientBindException;
import com.github.mikesafonov.smpp.core.exceptions.SmppException;
import com.github.mikesafonov.smpp.core.exceptions.SmppSessionException;
import com.github.mikesafonov.smpp.core.sender.MessageBuilder;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSenderClient
implements SenderClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardSenderClient.class);
    private static final int INVALID_PARAM = 101;
    private static final int INVALID_SENDING_ERROR = 102;
    private final long timeoutMillis;
    private final MessageBuilder messageBuilder;
    private final boolean ucs2Only;
    private final ConnectionManager connectionManager;
    private boolean inited = false;

    public StandardSenderClient(@NotNull ConnectionManager connectionManager, boolean ucs2Only, long timeoutMillis, @NotNull MessageBuilder messageBuilder) {
        this.messageBuilder = Objects.requireNonNull(messageBuilder);
        this.connectionManager = Objects.requireNonNull(connectionManager);
        this.ucs2Only = ucs2Only;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    @NotNull
    public String getId() {
        return this.connectionManager.getConfiguration().getName();
    }

    @Override
    public void setup() {
        if (!this.inited) {
            try {
                this.connectionManager.getSession();
            }
            catch (SmppSessionException e) {
                log.error(e.getErrorMessage(), (Throwable)e);
                throw new SenderClientBindException(String.format("Unable to bind with configuration: %s ", this.connectionManager.getConfiguration().configInformation()));
            }
            this.inited = true;
        }
    }

    @Override
    @NotNull
    public MessageResponse send(@NotNull Message message) {
        Objects.requireNonNull(message);
        if (this.isNullOrEmpty(message.getText())) {
            return MessageResponse.error(message, this.getId(), new MessageErrorInformation(0, "Empty message text"));
        }
        try {
            SubmitSm submitSm = this.messageBuilder.createSubmitSm(message, this.ucs2Only);
            SubmitSmResp send = this.send(submitSm);
            return this.analyzeResponse(message, send);
        }
        catch (IllegalAddressException e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.error(message, this.getId(), new MessageErrorInformation(101, e.getMessage()));
        }
        catch (SmppException e) {
            return MessageResponse.error(message, this.getId(), new MessageErrorInformation(e.getErrorCode(), e.getErrorMessage()));
        }
    }

    @Override
    @NotNull
    public CancelMessageResponse cancel(@NotNull CancelMessage cancelMessage) {
        Objects.requireNonNull(cancelMessage);
        if (this.isNullOrEmpty(cancelMessage.getMessageId())) {
            return CancelMessageResponse.error(cancelMessage, this.getId(), new MessageErrorInformation(0, "Empty message id"));
        }
        try {
            CancelSm cancelSm = this.messageBuilder.createCancelSm(cancelMessage);
            WindowFuture futureResponse = this.connectionManager.getSession().sendRequestPdu((PduRequest)cancelSm, this.timeoutMillis, true);
            if (futureResponse.await() && futureResponse.isDone() && futureResponse.isSuccess()) {
                return this.createCancelMessageResponse(cancelMessage, (WindowFuture<Integer, PduRequest, PduResponse>)futureResponse);
            }
            return CancelMessageResponse.error(cancelMessage, this.getId(), new MessageErrorInformation(101, "Unable to get response"));
        }
        catch (RecoverablePduException | SmppChannelException | SmppTimeoutException | UnrecoverablePduException | InterruptedException e) {
            log.error(e.getMessage(), e);
            return CancelMessageResponse.error(cancelMessage, this.getId(), new MessageErrorInformation(101, e.getMessage()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return CancelMessageResponse.error(cancelMessage, this.getId(), new MessageErrorInformation(102, "Unexpected exception"));
        }
    }

    @Override
    public Optional<ConnectionManager> getConnectionManager() {
        return Optional.of(this.connectionManager);
    }

    @NotNull
    private CancelMessageResponse createCancelMessageResponse(@NotNull CancelMessage cancelMessage, WindowFuture<Integer, PduRequest, PduResponse> futureResponse) {
        CancelSmResp cancelSmResp = (CancelSmResp)futureResponse.getResponse();
        if (cancelSmResp.getCommandStatus() == 0) {
            return CancelMessageResponse.success(cancelMessage, this.getId());
        }
        return CancelMessageResponse.error(cancelMessage, this.getId(), new MessageErrorInformation(101, cancelSmResp.getResultMessage()));
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private SubmitSmResp send(SubmitSm sm) {
        try {
            return this.connectionManager.getSession().submit(sm, this.timeoutMillis);
        }
        catch (SmppInvalidArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new SmppException(101, "Invalid param");
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new SmppException(102, "Cant send message");
        }
    }

    private MessageResponse analyzeResponse(Message message, SubmitSmResp submitSmResp) {
        if (submitSmResp.getCommandStatus() == 0) {
            return MessageResponse.success(message, this.getId(), submitSmResp.getMessageId());
        }
        return MessageResponse.error(message, this.getId(), new MessageErrorInformation(101, submitSmResp.getResultMessage()));
    }
}

