/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.sender;

import com.github.mikesafonov.smpp.core.connection.ConnectionManager;
import com.github.mikesafonov.smpp.core.dto.CancelMessage;
import com.github.mikesafonov.smpp.core.dto.CancelMessageResponse;
import com.github.mikesafonov.smpp.core.dto.Message;
import com.github.mikesafonov.smpp.core.dto.MessageResponse;
import com.github.mikesafonov.smpp.core.generators.SmppResultGenerator;
import com.github.mikesafonov.smpp.core.sender.SenderClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class TestSenderClient
implements SenderClient {
    private final List<String> allowedPhones;
    private final SenderClient senderClient;
    private final SmppResultGenerator smppResultGenerator;

    public TestSenderClient(@NotNull SenderClient senderClient, @NotNull List<String> allowedPhones, @NotNull SmppResultGenerator smppResultGenerator) {
        this.senderClient = Objects.requireNonNull(senderClient);
        this.allowedPhones = new ArrayList<String>(allowedPhones);
        this.smppResultGenerator = Objects.requireNonNull(smppResultGenerator);
    }

    @Override
    @NotNull
    public String getId() {
        return this.senderClient.getId();
    }

    @Override
    public void setup() {
        this.senderClient.setup();
    }

    @Override
    public MessageResponse send(Message message) {
        if (this.isAllowed(message.getMsisdn())) {
            return this.senderClient.send(message);
        }
        return this.smppResultGenerator.generate(this.senderClient.getId(), message);
    }

    @Override
    @NotNull
    public CancelMessageResponse cancel(@NotNull CancelMessage cancelMessage) {
        if (this.isAllowed(cancelMessage.getMsisdn())) {
            return this.senderClient.cancel(cancelMessage);
        }
        return this.smppResultGenerator.generate(this.senderClient.getId(), cancelMessage);
    }

    @Override
    public Optional<ConnectionManager> getConnectionManager() {
        return this.senderClient.getConnectionManager();
    }

    private boolean isAllowed(String phone) {
        return this.allowedPhones.contains(phone);
    }

    public List<String> getAllowedPhones() {
        return this.allowedPhones;
    }
}

