/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikesafonov.smpp.core.utils;

import com.cloudhopper.commons.charset.CharsetUtil;
import com.github.mikesafonov.smpp.core.utils.CountWithEncoding;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.lang.Nullable;

public final class MessageUtil {
    private static final Pattern PATTERN = Pattern.compile("^[A-Za-z0-9 \\r\\n@\u00a3$\u00a5\u00e8\u00e9\u00f9\u00ec\u00f2\u00c7\u00d8\u00f8\u00c5\u00e5\u0394_\u03a6\u0393\u039b\u03a9\u03a0\u03a8\u03a3\u0398\u039e\u00c6\u00e6\u00df\u00c9!\"#$%&'()*+,\\-./:;<=>?\u00a1\u00c4\u00d6\u00d1\u00dc\u00a7\u00bf\u00e4\u00f6\u00f1\u00fc\u00e0^{}\\\\\\[~\\]|\u20ac]*$");
    public static final int UCS_2_REGULAR_MESSAGE_LENGTH = 70;
    public static final int UCS_2_MULTIPART_MESSAGE_LENGTH = 67;
    public static final int GSM_7_REGULAR_MESSAGE_LENGTH = 160;
    public static final int GSM_7_MULTIPART_MESSAGE_LENGTH = 153;

    public static CountWithEncoding calculateCountSMS(@Nullable String message, boolean ucs2Only) {
        if (MessageUtil.isNullOrBlank(message)) {
            return CountWithEncoding.empty(CharsetUtil.CHARSET_UCS_2);
        }
        if (ucs2Only) {
            return new CountWithEncoding(MessageUtil.countUcs2(message.length()), CharsetUtil.CHARSET_UCS_2);
        }
        return MessageUtil.isGsm(message) ? new CountWithEncoding(MessageUtil.countGsm(message.length()), CharsetUtil.CHARSET_GSM) : new CountWithEncoding(MessageUtil.countUcs2(message.length()), CharsetUtil.CHARSET_UCS_2);
    }

    public static CountWithEncoding calculateCountSMS(@Nullable String message) {
        return MessageUtil.calculateCountSMS(message, false);
    }

    private static boolean isNullOrBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static boolean isGsm(@NotNull String message) {
        return PATTERN.matcher(message).matches();
    }

    private static int countUcs2(int length) {
        return MessageUtil.countFragments(length, 70, 67);
    }

    private static int countGsm(int length) {
        return MessageUtil.countFragments(length, 160, 153);
    }

    private static int countFragments(int length, int regular, int multipart) {
        if (length > regular) {
            int fragmentsCount = length / multipart;
            if (length % multipart > 0) {
                ++fragmentsCount;
            }
            return fragmentsCount;
        }
        return 1;
    }

    @Generated
    private MessageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

