/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.influxdb;

import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.influxdb.InfluxDBProperties;
import org.springframework.util.Assert;

public class InfluxDBConnectionFactory
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(InfluxDBConnectionFactory.class);
    private InfluxDB connection;
    private InfluxDBProperties properties;

    public InfluxDBConnectionFactory() {
    }

    public InfluxDBConnectionFactory(InfluxDBProperties properties) {
        this.properties = properties;
    }

    public InfluxDB getConnection() {
        Assert.notNull((Object)this.getProperties(), (String)"InfluxDBProperties are required");
        if (this.connection == null) {
            OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout((long)this.properties.getConnectTimeout(), TimeUnit.SECONDS).writeTimeout((long)this.properties.getWriteTimeout(), TimeUnit.SECONDS).readTimeout((long)this.properties.getReadTimeout(), TimeUnit.SECONDS);
            this.connection = InfluxDBFactory.connect((String)this.properties.getUrl(), (String)this.properties.getUsername(), (String)this.properties.getPassword(), (OkHttpClient.Builder)client);
            logger.debug("Using InfluxDB '{}' on '{}'", (Object)this.properties.getDatabase(), (Object)this.properties.getUrl());
            if (this.properties.isGzip()) {
                logger.debug("Enabled gzip compression for HTTP requests");
                this.connection.enableGzip();
            }
        }
        return this.connection;
    }

    public InfluxDBProperties getProperties() {
        return this.properties;
    }

    public void setProperties(InfluxDBProperties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getProperties(), (String)"InfluxDBProperties are required");
    }
}

