/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjakubowski84.parquet4s;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.github.mjakubowski84.parquet4s.BinaryValue;
import com.github.mjakubowski84.parquet4s.ColumnPath;
import com.github.mjakubowski84.parquet4s.Filter;
import com.github.mjakubowski84.parquet4s.IOOps;
import com.github.mjakubowski84.parquet4s.ParquetReadSupport;
import com.github.mjakubowski84.parquet4s.ParquetReader;
import com.github.mjakubowski84.parquet4s.ParquetRecordDecoder;
import com.github.mjakubowski84.parquet4s.ParquetRecordDecoder$;
import com.github.mjakubowski84.parquet4s.ParquetSchemaResolver;
import com.github.mjakubowski84.parquet4s.ParquetSchemaResolver$;
import com.github.mjakubowski84.parquet4s.ParquetWriter;
import com.github.mjakubowski84.parquet4s.PartitionFilter$;
import com.github.mjakubowski84.parquet4s.PartitionedDirectory;
import com.github.mjakubowski84.parquet4s.PartitionedPath;
import com.github.mjakubowski84.parquet4s.Path;
import com.github.mjakubowski84.parquet4s.RowParquetRecord;
import com.github.mjakubowski84.parquet4s.Value;
import com.github.mjakubowski84.parquet4s.ValueCodecConfiguration;
import com.github.mjakubowski84.parquet4s.ValueCodecConfiguration$;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class ParquetSource$
implements IOOps {
    public static ParquetSource$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ParquetSource$();
    }

    @Override
    public void validateWritePath(Path path, ParquetWriter.Options writeOptions) {
        IOOps.validateWritePath$(this, path, writeOptions);
    }

    @Override
    public Future<List<String>> filesAtPath(Path path, Configuration configuration, ExecutionContext ec) {
        return IOOps.filesAtPath$(this, path, configuration, ec);
    }

    @Override
    public Either<Exception, PartitionedDirectory> findPartitionedPaths(Path path, Configuration configuration) {
        return IOOps.findPartitionedPaths$(this, path, configuration);
    }

    private Logger logger$lzycompute() {
        ParquetSource$ parquetSource$ = this;
        synchronized (parquetSource$) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public <T> Source<T, NotUsed> com$github$mjakubowski84$parquet4s$ParquetSource$$apply(Path path, ParquetReader.Options options, Filter filter, Option<ParquetSchemaResolver<T>> projectedSchemaResolverOpt, ParquetRecordDecoder<T> evidence$8) {
        ValueCodecConfiguration valueCodecConfiguration = ValueCodecConfiguration$.MODULE$.apply(options);
        Configuration hadoopConf = options.hadoopConf();
        return (Source)this.findPartitionedPaths(path, hadoopConf).fold((Function1 & Serializable & scala.Serializable)cause -> Source$.MODULE$.failed(cause), (Function1 & Serializable & scala.Serializable)partitionedDirectory -> {
            Option projectedSchemaOpt = projectedSchemaResolverOpt.map((Function1 & Serializable & scala.Serializable)resolver -> ParquetSchemaResolver$.MODULE$.resolveSchema((Iterable)partitionedDirectory.schema(), resolver));
            Iterable sources = (Iterable)PartitionFilter$.MODULE$.filter(filter, valueCodecConfiguration, partitionedDirectory).map(MODULE$.createSource(valueCodecConfiguration, hadoopConf, (Option<MessageType>)projectedSchemaOpt, evidence$8).tupled(), Iterable$.MODULE$.canBuildFrom());
            return sources.isEmpty() ? Source$.MODULE$.empty() : (Source)sources.reduceLeft((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> (Source)x$1.concat((Graph)x$2));
        });
    }

    private <T> Function2<FilterCompat.Filter, PartitionedPath, Source<T, NotUsed>> createSource(ValueCodecConfiguration valueCodecConfiguration, Configuration hadoopConf, Option<MessageType> projectedSchemaOpt, ParquetRecordDecoder<T> evidence$9) {
        return (Function2 & Serializable & scala.Serializable)(filterCompat, partitionedPath) -> (Source)Source$.MODULE$.unfoldResource((Function0 & Serializable & scala.Serializable)() -> MODULE$.createReader(hadoopConf, (FilterCompat.Filter)filterCompat, (PartitionedPath)partitionedPath, projectedSchemaOpt), (Function1 & Serializable & scala.Serializable)reader -> Option$.MODULE$.apply(reader.read()), (Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable & scala.Serializable)record -> MODULE$.setPartitionValues((PartitionedPath)partitionedPath, (RowParquetRecord)record)).map((Function1 & Serializable & scala.Serializable)record -> ParquetSource$.decode$1(record, valueCodecConfiguration, evidence$9));
    }

    private <T> RowParquetRecord setPartitionValues(PartitionedPath partitionedPath, RowParquetRecord record) {
        return (RowParquetRecord)partitionedPath.partitions().foldLeft((Object)record, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            RowParquetRecord currentRecord;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    currentRecord = (RowParquetRecord)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            ColumnPath columnPath = (ColumnPath)tuple2._1();
            Binary value = (Binary)tuple2._2();
            RowParquetRecord rowParquetRecord = currentRecord.updated(columnPath, (Value)new BinaryValue(value));
            return rowParquetRecord;
        });
    }

    private ParquetReader<RowParquetRecord> createReader(Configuration hadoopConf, FilterCompat.Filter filterCompat, PartitionedPath partitionedPath, Option<MessageType> projectedSchemaOpt) {
        return ParquetReader.builder((ReadSupport)new ParquetReadSupport(projectedSchemaOpt), (org.apache.hadoop.fs.Path)partitionedPath.path().toHadoop()).withConf(hadoopConf).withFilter(filterCompat).build();
    }

    private static final Object decode$1(RowParquetRecord record, ValueCodecConfiguration valueCodecConfiguration$2, ParquetRecordDecoder evidence$9$1) {
        return ParquetRecordDecoder$.MODULE$.decode(record, valueCodecConfiguration$2, evidence$9$1);
    }

    private ParquetSource$() {
        MODULE$ = this;
        IOOps.$init$(this);
    }
}

