/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjakubowski84.parquet4s;

import com.github.mjakubowski84.parquet4s.BinaryValue;
import com.github.mjakubowski84.parquet4s.ColumnPath;
import com.github.mjakubowski84.parquet4s.ColumnProjection;
import com.github.mjakubowski84.parquet4s.Filter;
import com.github.mjakubowski84.parquet4s.HadoopParquetReader$;
import com.github.mjakubowski84.parquet4s.IOOps;
import com.github.mjakubowski84.parquet4s.ParquetReader;
import com.github.mjakubowski84.parquet4s.ParquetRecordDecoder;
import com.github.mjakubowski84.parquet4s.ParquetRecordDecoder$;
import com.github.mjakubowski84.parquet4s.ParquetSchemaResolver;
import com.github.mjakubowski84.parquet4s.ParquetSchemaResolver$;
import com.github.mjakubowski84.parquet4s.ParquetWriter;
import com.github.mjakubowski84.parquet4s.PartitionFilter$;
import com.github.mjakubowski84.parquet4s.PartitionedDirectory;
import com.github.mjakubowski84.parquet4s.PartitionedPath;
import com.github.mjakubowski84.parquet4s.Path;
import com.github.mjakubowski84.parquet4s.Path$;
import com.github.mjakubowski84.parquet4s.RowParquetRecord;
import com.github.mjakubowski84.parquet4s.ScalaCompat$stream$scaladsl$;
import com.github.mjakubowski84.parquet4s.Value;
import com.github.mjakubowski84.parquet4s.ValueCodecConfiguration;
import com.github.mjakubowski84.parquet4s.ValueCodecConfiguration$;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class ParquetSource$
implements IOOps {
    public static final ParquetSource$ MODULE$ = new ParquetSource$();
    private static final Logger logger;

    static {
        IOOps.$init$((IOOps)MODULE$);
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    public void validateWritePath(Path path, ParquetWriter.Options writeOptions) {
        IOOps.validateWritePath$((IOOps)this, (Path)path, (ParquetWriter.Options)writeOptions);
    }

    public Future<List<String>> filesAtPath(Path path, Configuration configuration, ExecutionContext ec) {
        return IOOps.filesAtPath$((IOOps)this, (Path)path, (Configuration)configuration, (ExecutionContext)ec);
    }

    public Either<Exception, PartitionedDirectory> findPartitionedPaths(Path path, Configuration configuration) {
        return IOOps.findPartitionedPaths$((IOOps)this, (Path)path, (Configuration)configuration);
    }

    public Logger logger() {
        return logger;
    }

    public <T> Source<T, NotUsed> com$github$mjakubowski84$parquet4s$ParquetSource$$apply(InputFile inputFile, ParquetReader.Options options, Filter filter, Option<ParquetSchemaResolver<T>> projectedSchemaResolverOpt, Seq<ColumnProjection> columnProjections, ParquetRecordDecoder<T> decoder) {
        Source source;
        ValueCodecConfiguration valueCodecConfiguration = ValueCodecConfiguration$.MODULE$.apply(options);
        Configuration hadoopConf = options.hadoopConf();
        InputFile inputFile2 = inputFile;
        if (inputFile2 instanceof HadoopInputFile) {
            HadoopInputFile hadoopInputFile = (HadoopInputFile)inputFile2;
            Source$ source$ = ScalaCompat$stream$scaladsl$.MODULE$.Source();
            source = (Source)this.findPartitionedPaths(Path$.MODULE$.apply(hadoopInputFile.getPath()), hadoopConf).fold((Function1 & Serializable)cause -> source$.failed(cause), (Function1 & Serializable)partitionedDirectory -> {
                Option projectedSchemaOpt = projectedSchemaResolverOpt.map((Function1 & Serializable)resolver -> ParquetSchemaResolver$.MODULE$.resolveSchema((Iterable)partitionedDirectory.schema(), resolver));
                Iterable sources = (Iterable)PartitionFilter$.MODULE$.filter(filter, valueCodecConfiguration, partitionedDirectory).map(MODULE$.createPartitionedSource((Option<MessageType>)projectedSchemaOpt, columnProjections, decoder).tupled());
                if (sources.isEmpty()) {
                    return ScalaCompat$stream$scaladsl$.MODULE$.Source().empty();
                }
                return (Source)sources.reduceLeft((Function2 & Serializable)(x$3, x$4) -> (Source)x$3.concat((Graph)x$4));
            });
        } else {
            Option projectedSchemaOpt = projectedSchemaResolverOpt.map((Function1 & Serializable)resolver -> ParquetSchemaResolver$.MODULE$.resolveSchema(resolver));
            source = this.createSource(inputFile, (Option<MessageType>)projectedSchemaOpt, columnProjections, filter.toFilterCompat(valueCodecConfiguration), decoder);
        }
        Source recordSource = source;
        return (Source)recordSource.map((Function1 & Serializable)record -> ParquetSource$.decode$1(record, valueCodecConfiguration, decoder));
    }

    private Function2<FilterCompat.Filter, PartitionedPath, Source<RowParquetRecord, NotUsed>> createPartitionedSource(Option<MessageType> projectedSchemaOpt, Seq<ColumnProjection> columnProjections, ParquetRecordDecoder<?> decoder) {
        return (Function2 & Serializable)(filterCompat, partitionedPath) -> (Source)MODULE$.createSource(partitionedPath.inputFile(), projectedSchemaOpt, columnProjections, (FilterCompat.Filter)filterCompat, decoder).map((Function1 & Serializable)record -> MODULE$.setPartitionValues((PartitionedPath)partitionedPath, (RowParquetRecord)record));
    }

    private Source<RowParquetRecord, NotUsed> createSource(InputFile inputFile, Option<MessageType> projectedSchemaOpt, Seq<ColumnProjection> columnProjections, FilterCompat.Filter filterCompat, ParquetRecordDecoder<?> decoder) {
        return ScalaCompat$stream$scaladsl$.MODULE$.Source().unfoldResource((Function0 & Serializable)() -> MODULE$.createReader(filterCompat, inputFile, projectedSchemaOpt, columnProjections, decoder), (Function1 & Serializable)reader -> Option$.MODULE$.apply(reader.read()), (Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
    }

    private RowParquetRecord setPartitionValues(PartitionedPath partitionedPath, RowParquetRecord record) {
        return (RowParquetRecord)partitionedPath.partitions().foldLeft((Object)record, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                RowParquetRecord currentRecord = (RowParquetRecord)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ColumnPath columnPath = (ColumnPath)tuple22._1();
                    Binary value = (Binary)tuple22._2();
                    return currentRecord.updated(columnPath, (Value)new BinaryValue(value));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private ParquetReader<RowParquetRecord> createReader(FilterCompat.Filter filterCompat, InputFile inputFile, Option<MessageType> projectedSchemaOpt, Seq<ColumnProjection> columnProjections, ParquetRecordDecoder<?> decoder) {
        return HadoopParquetReader$.MODULE$.apply(inputFile, projectedSchemaOpt, columnProjections, filterCompat, decoder).build();
    }

    private static final Object decode$1(RowParquetRecord record, ValueCodecConfiguration valueCodecConfiguration$1, ParquetRecordDecoder decoder$1) {
        return ParquetRecordDecoder$.MODULE$.decode(record, valueCodecConfiguration$1, decoder$1);
    }

    private ParquetSource$() {
    }
}

