/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty9.jupiter;

import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.jetty9.EmbeddedJetty;
import com.github.mjeanroy.junit.servers.jetty9.EmbeddedJettyFactory;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerExtension;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;

public class JettyServerExtension
extends JunitServerExtension {
    private static final Logger log = LoggerFactory.getLogger(JettyServerExtension.class);

    public JettyServerExtension() {
    }

    public JettyServerExtension(EmbeddedJetty jetty) {
        super((EmbeddedServer)jetty);
    }

    public JettyServerExtension(EmbeddedJettyConfiguration configuration) {
        super((AbstractConfiguration)configuration);
    }

    protected EmbeddedServer<?> instantiateServer(Class<?> testClass, AbstractConfiguration configuration) {
        log.debug("Instantiating embedded jetty for test class: {}", testClass);
        return EmbeddedJettyFactory.createFrom(testClass, configuration);
    }
}

