/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.github.mkolisnyk.cucumber.reporting.CucumberResultsCommon;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CucumberResultsOverview
extends CucumberResultsCommon {
    private String outputDirectory;
    private String outputName;

    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(String outputDirectoryValue) {
        this.outputDirectory = outputDirectoryValue;
    }

    public final String getOutputName() {
        return this.outputName;
    }

    public final void setOutputName(String outputNameValue) {
        this.outputName = outputNameValue;
    }

    private String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/feature-overview-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    private String getFeatureData(CucumberFeatureResult[] results) {
        int passed = 0;
        int failed = 0;
        int undefined = 0;
        for (CucumberFeatureResult result : results) {
            if (result.getStatus().trim().equalsIgnoreCase("passed")) {
                ++passed;
            }
            if (result.getStatus().trim().equalsIgnoreCase("failed")) {
                ++failed;
            }
            if (!result.getStatus().trim().equalsIgnoreCase("undefined")) continue;
            ++undefined;
        }
        return String.format("['Passed', %d], ['Failed', %d], ['Undefined', %d]", passed, failed, undefined);
    }

    private String getScenarioData(CucumberFeatureResult[] results) {
        int passed = 0;
        int failed = 0;
        int undefined = 0;
        for (CucumberFeatureResult result : results) {
            for (CucumberScenarioResult element : result.getElements()) {
                if (element.getStatus().trim().equalsIgnoreCase("passed")) {
                    ++passed;
                }
                if (element.getStatus().trim().equalsIgnoreCase("failed")) {
                    ++failed;
                }
                if (!element.getStatus().trim().equalsIgnoreCase("undefined")) continue;
                ++undefined;
            }
        }
        return String.format("['Passed', %d], ['Failed', %d], ['Undefined', %d]", passed, failed, undefined);
    }

    private String generateFeatureOverview(CucumberFeatureResult[] results) throws IOException {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Features Overview");
        String reportContent = "";
        reportContent = reportContent + "<h1>Features Status</h1><table><tr><th>Feature Name</th><th>Status</th><th>Passed</th><th>Failed</th><th>Undefined</th></tr>";
        for (CucumberFeatureResult result : results) {
            reportContent = reportContent + String.format("<tr class=\"%s\"><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%d</td></tr>", result.getStatus(), result.getName(), result.getStatus(), result.getPassed(), result.getFailed(), result.getUndefined());
        }
        reportContent = reportContent + "</table>";
        reportContent = reportContent + "<h1>Scenario Status</h1><table><tr><th>Feature Name</th><th>Scenario</th><th>Status</th><th>Passed</th><th>Failed</th><th>Undefined</th></tr>";
        for (CucumberFeatureResult result : results) {
            for (CucumberScenarioResult element : result.getElements()) {
                reportContent = reportContent + String.format("<tr class=\"%s\"><td>%s</td><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%d</td></tr>", element.getStatus(), result.getName(), element.getName(), element.getStatus(), element.getPassed(), element.getFailed(), element.getUndefined());
            }
        }
        reportContent = reportContent + "</table>";
        content = content.replaceAll("__REPORT__", reportContent);
        content = content.replaceAll("__FEATURE_DATA__", this.getFeatureData(results));
        content = content.replaceAll("__SCENARIO_DATA__", this.getScenarioData(results));
        return content;
    }

    public void executeFeaturesOverviewReport() throws Exception {
        CucumberFeatureResult[] features = this.readFileContent();
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-feature-overview.html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateFeatureOverview(features));
        WebClient webClient = new WebClient(BrowserVersion.INTERNET_EXPLORER_11);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        HtmlPage page = (HtmlPage)webClient.getPage(new URL("file://" + outFile.getAbsolutePath()).toExternalForm());
        String content = page.asXml();
        FileUtils.writeStringToFile((File)outFile, (String)content);
        webClient.close();
    }
}

