/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.types.usage.CucumberStep;
import com.github.mkolisnyk.cucumber.reporting.types.usage.CucumberStepDuration;
import com.github.mkolisnyk.cucumber.reporting.types.usage.CucumberStepSource;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.MapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.maven.reporting.MavenReportException;

public class CucumberUsageReporting {
    private String jsonUsageFile;
    private String outputDirectory;

    public String getDescription(Locale arg0) {
        return "HTML formatted Cucumber keywords usage report";
    }

    public String getName(Locale arg0) {
        return "Cucumber usage report";
    }

    public String getOutputName() {
        return "cucumber-usage-report";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getJsonUsageFile() {
        return this.jsonUsageFile;
    }

    public void setJsonUsageFile(String jsonUsageFileValue) {
        this.jsonUsageFile = jsonUsageFileValue;
    }

    public void setOutputDirectory(String outputDirectoryValue) {
        this.outputDirectory = outputDirectoryValue;
    }

    public LinkedHashMap<String, Integer> calculateStepsUsageScore(CucumberStepSource[] sources) {
        LinkedHashMap map = new LinkedHashMap();
        for (CucumberStepSource source : sources) {
            int totalSteps = 0;
            for (CucumberStep step : source.getSteps()) {
                totalSteps += step.getDurations().length;
            }
            map.put(source.getSource(), totalSteps);
        }
        map = (LinkedHashMap)MapUtils.sortByValue(map);
        return map;
    }

    public SortedMap<Integer, Integer> calculateStepsUsageCounts(CucumberStepSource[] sources) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (CucumberStepSource source : sources) {
            int stepsCount = 0;
            for (CucumberStep step : source.getSteps()) {
                stepsCount += step.getDurations().length;
            }
            if (!map.containsKey(stepsCount)) {
                map.put(stepsCount, 1);
                continue;
            }
            int prevNum = (Integer)map.get(stepsCount);
            map.remove(stepsCount);
            map.put(stepsCount, ++prevNum);
        }
        return map;
    }

    public double calculateStepsUsageAverage(SortedMap<Integer, Integer> statistics) {
        int totalSteps = 0;
        int totalUniqueSteps = 0;
        for (int i : statistics.keySet()) {
            totalSteps += i * (Integer)statistics.get(i);
            totalUniqueSteps += ((Integer)statistics.get(i)).intValue();
        }
        if (totalUniqueSteps == 0) {
            totalUniqueSteps = 1;
        }
        return (double)totalSteps / (double)totalUniqueSteps;
    }

    public int calculateStepsUsageMedian(SortedMap<Integer, Integer> statistics) {
        int totalSteps = 0;
        int usedSteps = 0;
        int median = 0;
        for (int i : statistics.keySet()) {
            totalSteps += ((Integer)statistics.get(i)).intValue();
        }
        for (int i : statistics.keySet()) {
            if ((usedSteps += ((Integer)statistics.get(i)).intValue()) * 2 < totalSteps) continue;
            median = i;
            break;
        }
        return median;
    }

    public int calculateTotalSteps(SortedMap<Integer, Integer> statistics) {
        int totalSteps = 0;
        for (int i : statistics.keySet()) {
            totalSteps += i * (Integer)statistics.get(i);
        }
        return totalSteps;
    }

    public int calculateUsedSteps(SortedMap<Integer, Integer> statistics) {
        int usedSteps = 0;
        for (int i : statistics.keySet()) {
            usedSteps += ((Integer)statistics.get(i)).intValue();
        }
        return usedSteps;
    }

    public int calculateStepsUsageMax(SortedMap<Integer, Integer> statistics) {
        int max = 0;
        for (int i : statistics.keySet()) {
            max = Math.max(max, (Integer)statistics.get(i));
        }
        return max;
    }

    protected String generateUsageOverviewGraphReport(CucumberStepSource[] sources) {
        int i;
        int hsize = 400;
        int vsize = 400;
        int hstart = 40;
        int vstart = 30;
        int hend = 350;
        int vend = 300;
        int hstep = 0;
        int vstep = 0;
        SortedMap<Integer, Integer> map = this.calculateStepsUsageCounts(sources);
        double hscale = 270.0 / ((double)map.lastKey().intValue() + 1.0);
        double vscale = 240.0 / ((double)this.calculateStepsUsageMax(map) + 1.0);
        double stepScale = 30.0;
        hstep = (int)(30.0 / hscale) + 1;
        vstep = (int)(30.0 / vscale) + 1;
        int median = this.calculateStepsUsageMedian(map);
        double average = this.calculateStepsUsageAverage(map);
        int hsizeMargin = 100;
        int smallMargin = 5;
        int midMargin = 10;
        int largeMargin = 20;
        String htmlContent = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"500\" height=\"400\"><defs><filter id=\"f1\" x=\"0\" y=\"0\" width=\"200%\" height=\"200%\"><feOffset result=\"offOut\" in=\"SourceAlpha\" dx=\"10\" dy=\"10\" /><feGaussianBlur result=\"blurOut\" in=\"offOut\" stdDeviation=\"10\" /><feBlend in=\"SourceGraphic\" in2=\"blurOut\" mode=\"normal\" /></filter><radialGradient id=\"grad1\" cx=\"0%\" cy=\"100%\" r=\"150%\" fx=\"0%\" fy=\"100%\"><stop offset=\"0%\" style=\"stop-color:white;stop-opacity:0.1\" /><stop offset=\"100%\" style=\"stop-color:gold;stop-opacity:0.7\" /></radialGradient><linearGradient id=\"grad2\" cx=\"0%\" cy=\"100%\" r=\"150%\" fx=\"0%\" fy=\"100%\"><stop offset=\"0%\" style=\"stop-color:red;stop-opacity:0.7\" /><stop offset=\"50%\" style=\"stop-color:yellow;stop-opacity:0.7\" /><stop offset=\"100%\" style=\"stop-color:green;stop-opacity:0.7\" /></linearGradient></defs><rect width=\"90%\" height=\"90%\" stroke=\"black\" stroke-width=\"1\" fill=\"url(#grad1)\" filter=\"url(#f1)\" /><line x1=\"40\" y1=\"30\" x2=\"40\" y2=\"300\" style=\"stroke:black;stroke-width:1\" /><line x1=\"40\" y1=\"300\" x2=\"350\" y2=\"300\" style=\"stroke:black;stroke-width:1\" /><polygon points=\"35,50 40,30 45,50\" style=\"fill:black;stroke:black;stroke-width:1\"/><polygon points=\"350,300 330,305 330,295\" style=\"fill:black;stroke:black;stroke-width:1\"/><polygon points=\"40,300";
        for (i = 0; i <= map.lastKey() + 1; ++i) {
            int value = 0;
            if (map.containsKey(i)) {
                value = (Integer)map.get(i);
            }
            htmlContent = htmlContent + " " + (40 + (int)((double)i * hscale)) + "," + (300 - (int)((double)value * vscale));
        }
        htmlContent = htmlContent + "\" style=\"stroke:black;stroke-width:1\"  fill=\"url(#grad2)\" />";
        for (i = 0; i <= map.lastKey(); i += hstep) {
            htmlContent = htmlContent + "<line x1=\"" + (40 + (int)((double)i * hscale)) + "\" y1=\"" + 300 + "\" x2=\"" + (40 + (int)((double)i * hscale)) + "\" y2=\"" + 305 + "\" style=\"stroke:black;stroke-width:1\" />" + "<text x=\"" + (40 + (int)((double)i * hscale)) + "\" y=\"" + 310 + "\" font-size = \"8\">" + i + "</text>";
        }
        for (i = 0; i <= this.calculateStepsUsageMax(map); i += vstep) {
            htmlContent = htmlContent + "<line x1=\"40\" y1=\"" + (300 - (int)((double)i * vscale)) + "\" x2=\"" + 35 + "\" y2=\"" + (300 - (int)((double)i * vscale)) + "\" style=\"stroke:black;stroke-width:1\" />" + "<text x=\"" + 35 + "\" y=\"" + (300 - (int)((double)i * vscale)) + "\" transform=\"rotate(-90 " + 35 + "," + (300 - (int)((double)i * vscale)) + ")\" font-size = \"8\">" + i + "</text>";
        }
        float usage30 = 30.0f;
        float usage70 = 70.0f;
        float usage100 = 100.0f;
        float usage = 100.0f * (1.0f - (float)this.calculateUsedSteps(map) / (float)this.calculateTotalSteps(map));
        String statusColor = "silver";
        statusColor = usage <= 30.0f ? "red" : (usage >= 70.0f ? "green" : "#BBBB00");
        htmlContent = htmlContent + "<line stroke-dasharray=\"10,10\" x1=\"" + (40.0 + (double)median * hscale) + "\" y1=\"" + 30 + "\" x2=\"" + (40.0 + (double)median * hscale) + "\" y2=\"" + 300 + "\" style=\"stroke:yellow;stroke-width:3\" />" + "<line stroke-dasharray=\"10,10\" x1=\"" + (40 + (int)(average * hscale)) + "\" y1=\"" + 30 + "\" x2=\"" + (40 + (int)(average * hscale)) + "\" y2=\"" + 300 + "\" style=\"stroke:red;stroke-width:3\" />" + "<rect x=\"60%\" y=\"20%\" width=\"28%\" height=\"20%\" stroke=\"black\"" + " stroke-width=\"1\" fill=\"white\" filter=\"url(#f1)\" />" + "<line x1=\"63%\" y1=\"29%\" x2=\"68%\" y2=\"29%\" stroke-dasharray=\"5,5\"" + " style=\"stroke:red;stroke-width:3\" /><text x=\"73%\" y=\"30%\"" + " font-weight = \"bold\" font-size = \"12\">Average</text>" + "<line x1=\"63%\" y1=\"34%\" x2=\"68%\" y2=\"34%\" stroke-dasharray=\"5,5\"" + " style=\"stroke:yellow;stroke-width:3\" /><text x=\"73%\" y=\"35%\"" + " font-weight = \"bold\" font-size = \"12\">Median</text>" + "<text x=\"60%\" y=\"55%\" font-weight = \"bold\" font-size = \"40\" fill=\"" + statusColor + "\">" + String.format("%.1f", Float.valueOf(usage)) + "%</text>" + "<text x=\"66%\" y=\"60%\" font-weight = \"bold\" font-size = \"16\" fill=\"" + statusColor + "\">Re-use</text>" + "<text x=\"120\" y=\"330\" font-weight = \"bold\" font-size = \"14\" >Step re-use count</text>" + "<text x=\"20\" y=\"220\" font-weight = \"bold\" font-size = \"14\"" + " transform=\"rotate(-90 20,220)\">Steps count</text>" + "</svg>";
        return htmlContent;
    }

    protected String generateUsageOverviewTableReport(CucumberStepSource[] sources) {
        LinkedHashMap<String, Integer> map = this.calculateStepsUsageScore(sources);
        String content = "<table><tr><th>Expression</th><th>Occurences</th></tr>";
        for (String key : map.keySet()) {
            content = content + "<tr><td width=\"80%\">" + key + "</td><td>" + map.get(key) + "</td></tr>";
        }
        content = content + "</table>";
        return content;
    }

    protected String generateUsageDetailedReport(CucumberStepSource[] sources) {
        String content = "";
        for (CucumberStepSource source : sources) {
            content = content + "<h3>" + source.getSource() + "</h3>" + "<table><tr><th>Step Name</th><th>Duration</th><th>Location</th></tr>";
            for (CucumberStep step : source.getSteps()) {
                content = content + "<tr><td>" + step.getName() + "</td><td> - </td><td> - </td></tr>";
                for (CucumberStepDuration duration : step.getDurations()) {
                    content = content + "<tr><td></td><td>" + duration.getDuration() + "</td><td>" + duration.getLocation() + "</td></tr>";
                }
            }
            content = content + "</table>";
        }
        return content;
    }

    public CucumberStepSource[] getStepSources(String filePath) throws Exception {
        FileInputStream fis = null;
        JsonReader jr = null;
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        fis = new FileInputStream(file);
        jr = new JsonReader((InputStream)fis, true);
        JsonObject source = (JsonObject)jr.readObject();
        Object[] objs = (Object[])source.get((Object)"@items");
        CucumberStepSource[] sources = new CucumberStepSource[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            sources[i] = new CucumberStepSource((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
        jr.close();
        fis.close();
        return sources;
    }

    private String generateStyle() {
        return "h1 {background-color:#9999CC}" + System.lineSeparator() + "h2 {background-color:#BBBBCC}" + System.lineSeparator() + "h3 {background-color:#DDDDFF}" + System.lineSeparator() + "th {border:1px solid black;background-color:#CCCCDD;}" + System.lineSeparator() + "td{border:1px solid black;}" + System.lineSeparator() + "table{border:1px solid black;border-collapse: collapse;}" + System.lineSeparator() + "tr:nth-child(even) {background: #CCC}" + System.lineSeparator() + "tr:nth-child(odd) {background: #FFF}";
    }

    public void executeReport() throws MavenReportException {
        try {
            CucumberStepSource[] sources = this.getStepSources(this.jsonUsageFile);
            String output = "<html><head><style type=\"text/css\">" + this.generateStyle() + "</style>" + "<title>Cucumber Steps Usage Report</title></head>" + "<body><h1>Cucumber Usage Statistics</h1>" + "<h2>Overview Graph</h2><p>" + this.generateUsageOverviewGraphReport(sources) + "</p>" + "<h2>Overview Table</h2><p>" + this.generateUsageOverviewTableReport(sources) + "</p>" + "<h1>Cucumber Usage Detailed Information</h1><p>" + this.generateUsageDetailedReport(sources) + "</p></body></html>";
            File report = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + ".html");
            FileUtils.writeStringToFile((File)report, (String)output);
        }
        catch (Exception e) {
            throw new MavenReportException("Error occured while generating Cucumber usage report", e);
        }
    }
}

