/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.result;

import com.cedarsoftware.util.io.JsonObject;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberTagResults;
import org.apache.commons.lang.ArrayUtils;

public class CucumberFeatureResult {
    private String id;
    private CucumberTagResults[] tags;
    private String description;
    private String name;
    private String keyword;
    private Long line;
    private CucumberScenarioResult[] elements;
    private String uri;
    private float duration;
    private int passed = 0;
    private int failed = 0;
    private int undefined = 0;

    public CucumberFeatureResult(JsonObject<String, Object> json) {
        int i;
        this.id = (String)json.get((Object)"id");
        JsonObject tagEntry = (JsonObject)json.get((Object)"tags");
        Object[] objs = new Object[]{};
        if (tagEntry != null) {
            objs = (Object[])((JsonObject)json.get((Object)"tags")).get((Object)"@items");
        }
        this.tags = new CucumberTagResults[objs.length];
        for (i = 0; i < objs.length; ++i) {
            this.tags[i] = new CucumberTagResults((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
        this.description = (String)json.get((Object)"description");
        this.name = (String)json.get((Object)"name");
        this.keyword = (String)json.get((Object)"keyword");
        this.line = (Long)json.get((Object)"line");
        objs = (Object[])((JsonObject)json.get((Object)"elements")).get((Object)"@items");
        this.elements = new CucumberScenarioResult[objs.length];
        for (i = 0; i < objs.length; ++i) {
            this.elements[i] = new CucumberScenarioResult((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
        this.uri = (String)json.get((Object)"uri");
    }

    public void valuate() {
        this.passed = 0;
        this.failed = 0;
        this.undefined = 0;
        this.duration = 0.0f;
        for (CucumberScenarioResult scenario : this.elements) {
            scenario.valuate();
            if (scenario.getFailed() > 0) {
                ++this.failed;
            } else if (scenario.getUndefined() > 0) {
                ++this.undefined;
            } else {
                ++this.passed;
            }
            this.duration = (float)((double)this.duration + scenario.getDuration());
        }
    }

    public String getStatus() {
        this.valuate();
        if (this.getFailed() > 0) {
            return "failed";
        }
        if (this.getUndefined() > 0) {
            return "undefined";
        }
        return "passed";
    }

    public final int getPassed() {
        return this.passed;
    }

    public final int getFailed() {
        return this.failed;
    }

    public final int getUndefined() {
        return this.undefined;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String idValue) {
        this.id = idValue;
    }

    public final CucumberTagResults[] getTags() {
        return this.tags;
    }

    public final void setTags(CucumberTagResults[] tagsValue) {
        this.tags = tagsValue;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String descriptionValue) {
        this.description = descriptionValue;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String nameValue) {
        this.name = nameValue;
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public final void setKeyword(String keywordValue) {
        this.keyword = keywordValue;
    }

    public final Long getLine() {
        return this.line;
    }

    public final void setLine(Long lineValue) {
        this.line = lineValue;
    }

    public final CucumberScenarioResult[] getElements() {
        return this.elements;
    }

    public final void setElements(CucumberScenarioResult[] elementsValue) {
        this.elements = elementsValue;
    }

    public final String getUri() {
        return this.uri;
    }

    public final void setUri(String uriValue) {
        this.uri = uriValue;
    }

    public final float getDuration() {
        return this.duration;
    }

    public void aggregateScenarioResults(boolean collapse) {
        String prevId = "";
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].getKeyword().equalsIgnoreCase("Background")) continue;
            if (this.elements[i].getId().equals(prevId)) {
                this.elements[i].addRerunAttempts(this.elements[i - 1].getRerunAttempts() + 1);
                if (collapse) {
                    this.elements = (CucumberScenarioResult[])ArrayUtils.remove((Object[])this.elements, (int)(i - 1));
                    prevId = this.elements[--i].getId();
                    continue;
                }
                prevId = this.elements[i].getId();
                this.elements[i].setId(String.format("%s-retry%d", this.elements[i].getId(), this.elements[i].getRerunAttempts()));
                this.elements[i].setName(String.format("%s (retry %d)", this.elements[i].getName(), this.elements[i].getRerunAttempts()));
                continue;
            }
            prevId = this.elements[i].getId();
        }
    }
}

