/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.result;

import com.cedarsoftware.util.io.JsonObject;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberBeforeAfterResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberTagResults;

public class CucumberScenarioResult {
    private String id;
    private CucumberTagResults[] tags;
    private String description;
    private String name;
    private String keyword;
    private Long line;
    private CucumberStepResult[] steps;
    private String type;
    private CucumberBeforeAfterResult before;
    private CucumberBeforeAfterResult after;
    private int passed = 0;
    private int failed = 0;
    private int undefined = 0;
    private double duration = 0.0;
    private int rerunAttempts = 0;

    public CucumberScenarioResult(JsonObject<String, Object> json) {
        int i;
        Object[] objs;
        this.id = (String)json.get((Object)"id");
        this.description = (String)json.get((Object)"description");
        this.name = (String)json.get((Object)"name");
        this.keyword = (String)json.get((Object)"keyword");
        this.line = (Long)json.get((Object)"line");
        this.type = (String)json.get((Object)"type");
        if (json.containsKey((Object)"before")) {
            objs = (Object[])((JsonObject)json.get((Object)"before")).get((Object)"@items");
            for (i = 0; i < objs.length; ++i) {
                this.before = new CucumberBeforeAfterResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        if (json.containsKey((Object)"after")) {
            objs = (Object[])((JsonObject)json.get((Object)"after")).get((Object)"@items");
            for (i = 0; i < objs.length; ++i) {
                this.after = new CucumberBeforeAfterResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        if (json.containsKey((Object)"steps")) {
            objs = (Object[])((JsonObject)json.get((Object)"steps")).get((Object)"@items");
            this.steps = new CucumberStepResult[objs.length];
            for (i = 0; i < objs.length; ++i) {
                this.steps[i] = new CucumberStepResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            }
        }
        JsonObject tagEntry = (JsonObject)json.get((Object)"tags");
        Object[] objs2 = new Object[]{};
        if (tagEntry != null) {
            objs2 = (Object[])((JsonObject)json.get((Object)"tags")).get((Object)"@items");
        }
        this.tags = new CucumberTagResults[objs2.length];
        for (int i2 = 0; i2 < objs2.length; ++i2) {
            this.tags[i2] = new CucumberTagResults((JsonObject<String, Object>)((JsonObject)objs2[i2]));
        }
    }

    public void valuate() {
        int nanosecondsInMillisecond = 1000000;
        float millesecondsInSecond = 1000.0f;
        this.passed = 0;
        this.failed = 0;
        this.undefined = 0;
        this.duration = 0.0;
        if (this.steps == null) {
            return;
        }
        for (CucumberStepResult step : this.steps) {
            String status = step.getResult().getStatus();
            if (status.equalsIgnoreCase("passed")) {
                ++this.passed;
            } else if (status.equalsIgnoreCase("failed")) {
                ++this.failed;
            } else {
                ++this.undefined;
            }
            this.duration += (double)((float)(step.getResult().getDuration() / 1000000L) / 1000.0f);
        }
        if (this.getBefore() != null) {
            this.duration += (double)((float)(this.getBefore().getResult().getDuration() / 1000000L) / 1000.0f);
        }
        if (this.getAfter() != null) {
            this.duration += (double)((float)(this.getAfter().getResult().getDuration() / 1000000L) / 1000.0f);
        }
    }

    public final int getPassed() {
        return this.passed;
    }

    public final int getFailed() {
        return this.failed;
    }

    public final int getUndefined() {
        return this.undefined;
    }

    public String getStatus() {
        this.valuate();
        if (this.getFailed() > 0) {
            return "failed";
        }
        if (this.getUndefined() > 0) {
            return "undefined";
        }
        if (this.getPassed() > 0) {
            return "passed";
        }
        return "undefined";
    }

    public final String getId() {
        return this.id;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final String getKeyword() {
        return this.keyword;
    }

    public final Long getLine() {
        return this.line;
    }

    public final CucumberStepResult[] getSteps() {
        return this.steps;
    }

    public final String getType() {
        return this.type;
    }

    public final void setId(String idValue) {
        this.id = idValue;
    }

    public final void setDescription(String descriptionValue) {
        this.description = descriptionValue;
    }

    public final void setName(String nameValue) {
        this.name = nameValue;
    }

    public final void setKeyword(String keywordValue) {
        this.keyword = keywordValue;
    }

    public final void setLine(Long lineValue) {
        this.line = lineValue;
    }

    public final void setSteps(CucumberStepResult[] stepsValue) {
        this.steps = stepsValue;
    }

    public final void setType(String typeValue) {
        this.type = typeValue;
    }

    public final CucumberTagResults[] getTags() {
        return this.tags;
    }

    public final void setTags(CucumberTagResults[] tagsValue) {
        this.tags = tagsValue;
    }

    public final double getDuration() {
        return this.duration;
    }

    public final CucumberBeforeAfterResult getBefore() {
        return this.before;
    }

    public final CucumberBeforeAfterResult getAfter() {
        return this.after;
    }

    public final int getRerunAttempts() {
        return this.rerunAttempts;
    }

    public void addRerunAttempts(int count) {
        this.rerunAttempts += count;
    }
}

