/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.reporting.CucumberDetailedResults;
import com.github.mkolisnyk.cucumber.reporting.CucumberResultsOverview;
import com.github.mkolisnyk.cucumber.reporting.CucumberUsageReporting;
import com.github.mkolisnyk.cucumber.runner.ExtendedFeatureRunner;
import com.github.mkolisnyk.cucumber.runner.ExtendedRuntimeOptions;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.junit.Assertions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.reporting.MavenReportException;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class ExtendedCucumber
extends ParentRunner<ExtendedFeatureRunner> {
    private final JUnitReporter jUnitReporter;
    private final List<ExtendedFeatureRunner> children = new ArrayList<ExtendedFeatureRunner>();
    private final Runtime runtime;
    private final ExtendedRuntimeOptions extendedOptions;

    public ExtendedCucumber(Class clazz) throws InitializationError, IOException {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.runtime = this.createRuntime((ResourceLoader)resourceLoader, classLoader, runtimeOptions);
        this.extendedOptions = new ExtendedRuntimeOptions(clazz);
        List cucumberFeatures = runtimeOptions.cucumberFeatures((ResourceLoader)resourceLoader);
        this.jUnitReporter = new JUnitReporter(runtimeOptions.reporter(classLoader), runtimeOptions.formatter(classLoader), runtimeOptions.isStrict());
        this.addChildren(cucumberFeatures);
    }

    protected Runtime createRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) throws InitializationError, IOException {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        return new Runtime(resourceLoader, (ClassFinder)classFinder, classLoader, runtimeOptions);
    }

    public List<ExtendedFeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ExtendedFeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(ExtendedFeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private void runUsageReport() {
        CucumberUsageReporting report = new CucumberUsageReporting();
        report.setOutputDirectory(this.extendedOptions.getOutputFolder());
        report.setJsonUsageFile(this.extendedOptions.getJsonUsageReportPath());
        try {
            report.executeReport();
        }
        catch (MavenReportException e) {
            e.printStackTrace();
        }
    }

    private void runOverviewReport() {
        CucumberResultsOverview results = new CucumberResultsOverview();
        results.setOutputDirectory(this.extendedOptions.getOutputFolder());
        results.setOutputName(this.extendedOptions.getReportPrefix());
        results.setSourceFile(this.extendedOptions.getJsonReportPath());
        try {
            results.executeFeaturesOverviewReport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runDetailedReport() {
        CucumberDetailedResults results = new CucumberDetailedResults();
        results.setOutputDirectory(this.extendedOptions.getOutputFolder());
        results.setOutputName(this.extendedOptions.getReportPrefix());
        results.setSourceFile(this.extendedOptions.getJsonReportPath());
        results.setScreenShotLocation(this.extendedOptions.getScreenShotLocation());
        results.setScreenShotWidth(this.extendedOptions.getScreenShotSize());
        try {
            results.executeDetailedResultsReport(this.extendedOptions.isToPDF(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runDetailedAggregatedReport() {
        CucumberDetailedResults results = new CucumberDetailedResults();
        results.setOutputDirectory(this.extendedOptions.getOutputFolder());
        results.setOutputName(this.extendedOptions.getReportPrefix());
        results.setSourceFile(this.extendedOptions.getJsonReportPath());
        results.setScreenShotLocation(this.extendedOptions.getScreenShotLocation());
        results.setScreenShotWidth(this.extendedOptions.getScreenShotSize());
        try {
            results.executeDetailedResultsReport(this.extendedOptions.isToPDF(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        this.jUnitReporter.done();
        this.jUnitReporter.close();
        this.runtime.printSummary();
        if (this.extendedOptions.isUsageReport()) {
            this.runUsageReport();
        }
        if (this.extendedOptions.isOverviewReport()) {
            this.runOverviewReport();
        }
        if (this.extendedOptions.isDetailedReport()) {
            this.runDetailedReport();
        }
        if (this.extendedOptions.isDetailedAggregatedReport()) {
            this.runDetailedAggregatedReport();
        }
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            this.children.add(new ExtendedFeatureRunner(cucumberFeature, this.runtime, this.jUnitReporter, this.extendedOptions.getRetryCount()));
        }
    }
}

