/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.formatter;

import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DBFormatter
implements Formatter,
Reporter {
    private String connectionString;

    public DBFormatter(File output) throws IOException {
        this.connectionString = output.getName();
    }

    @SafeVarargs
    final ResultSet executeQuery(String query, Pair<Integer, Object> ... params) {
        ResultSet result = null;
        return result;
    }

    public void before(Match match, Result result) {
        System.out.println("[BEFORE]");
    }

    public void result(Result result) {
        System.out.println("[RESULT]");
    }

    public void after(Match match, Result result) {
        System.out.println("[AFTER]");
    }

    public void match(Match match) {
        System.out.println("[MATCH]");
    }

    public void embedding(String mimeType, byte[] data) {
        System.out.println("");
    }

    public void write(String text) {
        System.out.println("[WRITE] " + text);
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        System.out.println("[SYNTAX ERROR]");
    }

    public void uri(String uri) {
        System.out.println("[URI]" + uri);
    }

    public void feature(Feature feature) {
        System.out.println("[FEATURE]");
        this.executeQuery("EXEC [cukes].[StartFeature] ?,?,?", new Pair[]{new ImmutablePair((Object)12, (Object)feature.getId()), new ImmutablePair((Object)12, (Object)feature.getName()), new ImmutablePair((Object)12, (Object)feature.getDescription())});
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        System.out.println("[SCENARIO OUTLINE]");
    }

    public void examples(Examples examples) {
        System.out.println("[EXAMPLES]");
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        System.out.println("[START SCENARIO]");
    }

    public void background(Background background) {
        System.out.println("[BACKGROUND]");
    }

    public void scenario(Scenario scenario) {
        System.out.println(String.format("[SCENARIO] id: %s .. Name: %s", scenario.getId(), scenario.getName()));
        this.executeQuery("EXEC [cukes].[StartScenario] ?,?,?,?", new Pair[]{new ImmutablePair((Object)12, (Object)scenario.getId()), new ImmutablePair((Object)12, (Object)scenario.getName()), new ImmutablePair((Object)12, (Object)scenario.getDescription()), new ImmutablePair((Object)12, (Object)scenario.getKeyword())});
    }

    public void step(Step step) {
        System.out.println(String.format("[STEP] %s", step.getName()));
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        System.out.println("[END SCENARIO]");
    }

    public void done() {
        System.out.println("[DONE]");
    }

    public void close() {
        System.out.println("[CLOSE]");
    }

    public void eof() {
        System.out.println("[EOF]");
    }
}

