/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.CucumberResultsCommon;
import com.github.mkolisnyk.cucumber.reporting.CucumberResultsOverview;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownCellDisplayType;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownReportInfo;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownReportModel;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownStats;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownTable;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.DataDimension;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;

public class CucumberBreakdownReport
extends CucumberResultsCommon {
    private static final int RED = 0xFF0000;
    private static final int GREEN = 65280;
    private static final int GRAY = 0xBBBBBB;
    private static final int TIMEOUT_MULTIPLIER = 3;

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        return null;
    }

    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/breakdown-report-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    public void executeReport(BreakdownReportInfo info, BreakdownTable table, boolean toPDF) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(true);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + info.getReportSuffix() + ".html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateBreakdownReport(features, info, table));
        if (toPDF) {
            this.exportToPDF(outFile, info.getReportSuffix());
        }
    }

    public void executeReport(BreakdownTable table, boolean toPDF) throws Exception {
        this.executeReport(new BreakdownReportInfo(table), table, toPDF);
    }

    public void executeReport(BreakdownReportModel model, boolean toPDF) throws Exception {
        boolean frameGenerated = false;
        model.initRedirectSequence("./" + this.getOutputName() + "-");
        for (BreakdownReportInfo info : model.getReportsInfo()) {
            if (info.getRefreshTimeout() > 0 && !frameGenerated) {
                frameGenerated = true;
                this.generateFrameFile(model);
            }
            this.executeReport(info, info.getTable(), toPDF);
        }
    }

    public void executeReport(BreakdownReportModel model) throws Exception {
        this.executeReport(model, false);
    }

    public void executeReport(File config, boolean toPDF) throws Exception {
        BreakdownReportModel model = (BreakdownReportModel)JsonReader.jsonToJava((String)FileUtils.readFileToString((File)config));
        this.executeReport(model, toPDF);
    }

    public void executeReport(File config) throws Exception {
        this.executeReport(config, false);
    }

    private void generateFrameFile(BreakdownReportModel model) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/breakdown-frame.html");
        String content = IOUtils.toString((InputStream)is);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-frame.html");
        content = content.replaceAll("__THIS__", outFile.getName());
        for (BreakdownReportInfo item : model.getReportsInfo()) {
            if (item.getRefreshTimeout() <= 0) continue;
            content = content.replaceAll("__FIRST__", "./" + this.getOutputName() + "-" + item.getReportSuffix() + ".html");
            break;
        }
        int totalTimeout = 0;
        for (BreakdownReportInfo item : model.getReportsInfo()) {
            if (item.getRefreshTimeout() <= 0) continue;
            totalTimeout += item.getRefreshTimeout();
        }
        content = content.replaceAll("__TIMEOUT__", "" + (totalTimeout *= 3));
        FileUtils.writeStringToFile((File)outFile, (String)content);
    }

    private String generateBreakdownReport(CucumberFeatureResult[] features, BreakdownReportInfo info, BreakdownTable table) throws Exception {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", info.getTitle());
        if (info.getRefreshTimeout() > 0 && StringUtils.isNotBlank((CharSequence)info.getNextFile())) {
            String refreshHeader = String.format("<meta http-equiv=\"Refresh\" content=\"%d; url=%s\" />", info.getRefreshTimeout(), info.getNextFile());
            content = content.replaceAll("__REFRESH__", refreshHeader);
        } else {
            content = content.replaceAll("__REFRESH__", "");
        }
        content = content.replaceAll("__REPORT__", this.generateBreakdownTable(features, table));
        content = this.replaceHtmlEntitiesWithCodes(content);
        content = content.replaceAll("[$]", "&#36;");
        return content;
    }

    private String generateBreakdownTable(CucumberFeatureResult[] features, BreakdownTable table) throws Exception {
        String content = String.format("<table class=\"hoverTable\"><thead>%s</thead><tbody>%s</tbody></table>", this.generateHeader(table), this.generateBody(table, features));
        return content;
    }

    private String generateHeader(BreakdownTable table) {
        int colOffset = table.getRows().depth();
        int rowOffset = table.getCols().depth();
        String content = String.format("<tr><th colspan=\"%d\" rowspan=\"%d\">&nbsp;</th>", colOffset, rowOffset);
        for (int i = 0; i < rowOffset; ++i) {
            DataDimension[] line;
            for (DataDimension item : line = table.getCols().getRow(i)) {
                content = item.depth() == 1 ? content.concat(String.format("<th colspan=\"%d\" rowspan=\"%d\">%s</th>", item.width(), rowOffset - item.depth() - i + 1, item.getAlias())) : content.concat(String.format("<th colspan=\"%d\" rowspan=\"%d\">%s</th>", item.width(), 1, item.getAlias()));
            }
            content = content.concat("</tr><tr>");
        }
        content = content.concat("</tr>");
        return content;
    }

    private String generateRowHeading(DataDimension data, int maxDepth, int level) {
        int cellDepth = 1;
        String aliasText = data.getAlias();
        if (data.depth() == 1) {
            cellDepth = maxDepth - level + 1;
        }
        String content = String.format("<th colspan=\"%d\" rowspan=\"%d\">%s</th>", cellDepth, data.width(), aliasText);
        if (data.hasSubElements()) {
            for (DataDimension item : data.getSubElements()) {
                content = content.concat(this.generateRowHeading(item, maxDepth, level + 1));
            }
        } else {
            content = content.concat("</tr><tr>");
        }
        return content;
    }

    private String generateRowHeading(BreakdownTable table) {
        DataDimension rows = table.getRows();
        String content = "<tr>" + this.generateRowHeading(rows, rows.depth(), 1) + "</tr>";
        return content;
    }

    private String generateBody(BreakdownTable table, CucumberFeatureResult[] features) throws Exception {
        Object[] scenarios = new CucumberScenarioResult[]{};
        for (CucumberFeatureResult feature : features) {
            scenarios = (CucumberScenarioResult[])ArrayUtils.addAll((Object[])scenarios, (Object[])feature.getElements());
        }
        BreakdownStats[][] results = table.valuate((CucumberScenarioResult[])scenarios);
        String rowHeadings = this.generateRowHeading(table);
        String[] headingRows = rowHeadings.split("</tr>");
        Assert.assertEquals((int)(headingRows.length - 1), (int)results.length);
        String content = "";
        for (int i = 0; i < results.length; ++i) {
            String row = headingRows[i];
            for (int j = 0; j < results[i].length; ++j) {
                row = row.concat(this.drawCell(results[i][j], table.getDisplayType()));
            }
            row = row.concat("</tr>");
            content = content.concat(row);
        }
        return content;
    }

    private String drawCell(BreakdownStats stats, BreakdownCellDisplayType type) throws Exception {
        HashMap drawCellMap = new HashMap<BreakdownCellDisplayType, Class<?>>(){
            {
                this.put(BreakdownCellDisplayType.BARS_ONLY, BarCellDrawer.class);
                this.put(BreakdownCellDisplayType.BARS_WITH_NUMBERS, BarNumberCellDrawer.class);
                this.put(BreakdownCellDisplayType.NUMBERS_ONLY, NumberOnlyCellDrawer.class);
                this.put(BreakdownCellDisplayType.PIE_CHART, PieChartCellDrawer.class);
            }
        };
        double total = stats.getFailed() + stats.getPassed() + stats.getSkipped();
        if (total <= 0.0) {
            return String.format("<td bgcolor=\"silver\"><center><b>N/A</b></center></td>", new Object[0]);
        }
        CellDrawer drawer = (CellDrawer)((Class)drawCellMap.get((Object)type)).getConstructor(this.getClass()).newInstance(this);
        return drawer.drawCell(stats);
    }

    private class PieChartCellDrawer
    implements CellDrawer {
        @Override
        public String drawCell(BreakdownStats stats) throws Exception {
            CucumberResultsOverview generator = new CucumberResultsOverview();
            String chartHtml = "";
            double total = stats.getFailed() + stats.getPassed() + stats.getSkipped();
            if (total > 0.0) {
                chartHtml = "<td>" + generator.generatePieChart(450, 300, new int[]{stats.getPassed(), stats.getFailed(), stats.getSkipped()}, new String[]{"Passed", "Failed", "Skipped"}, new String[]{"green", "red", "silver"}, new String[]{"darkgreen", "darkred", "darkgray"}, 20, 2) + "</td>";
                return chartHtml;
            }
            return String.format("<td bgcolor=\"silver\"><center><b>N/A</b></center></td>", new Object[0]);
        }
    }

    private class NumberOnlyCellDrawer
    implements CellDrawer {
        @Override
        public String drawCell(BreakdownStats stats) {
            String output = "<td><center><b>";
            if (stats.getPassed() > 0) {
                output = output.concat(String.format("<span class=\"passed\">%d</span> ", stats.getPassed()));
            }
            if (stats.getFailed() > 0) {
                output = output.concat(String.format("<span class=\"failed\">%d</span> ", stats.getFailed()));
            }
            if (stats.getSkipped() > 0) {
                output = output.concat(String.format("<span class=\"skipped\">%d</span> ", stats.getSkipped()));
            }
            return output + "</b></center></td>";
        }
    }

    private class BarNumberCellDrawer
    implements CellDrawer {
        @Override
        public String drawCell(BreakdownStats stats) {
            BarCellDrawer barDrawer = new BarCellDrawer();
            String barHtml = barDrawer.drawCell(stats);
            NumberOnlyCellDrawer numberDrawer = new NumberOnlyCellDrawer();
            String numberHtml = numberDrawer.drawCell(stats);
            barHtml = barHtml.replaceAll("</tr></table>", "</tr>" + numberHtml + "</table>");
            return barHtml;
        }
    }

    private class BarCellDrawer
    implements CellDrawer {
        private String drawCellValues(int passed, int failed, int skipped) {
            String output = "";
            if (passed > 0) {
                output = output.concat(String.format("Passed: %d ", passed));
            }
            if (failed > 0) {
                output = output.concat(String.format("Failed: %d ", failed));
            }
            if (skipped > 0) {
                output = output.concat(String.format("Skipped: %d ", skipped));
            }
            return output;
        }

        @Override
        public String drawCell(BreakdownStats stats) {
            int cellSize = 30;
            double total = stats.getFailed() + stats.getPassed() + stats.getSkipped();
            if (total > 0.0) {
                int passedRatio = (int)(30.0 * ((double)stats.getPassed() / total));
                int failedRatio = (int)(30.0 * ((double)stats.getFailed() / total));
                int skippedRatio = (int)(30.0 * ((double)stats.getSkipped() / total));
                if (stats.getFailed() > 0) {
                    ++failedRatio;
                }
                return String.format("<td><table width=\"100%%\"><tr><td><a title=\"%s\"><svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"100%%\" height=\"30\"><rect y=\"%d\" width=\"100%%\" height=\"%d\" stroke=\"black\" stroke-width=\"1\" fill=\"green\"></rect><rect y=\"%d\" width=\"100%%\" height=\"%d\" stroke=\"red\" stroke-width=\"1\" fill=\"red\"></rect><rect y=\"%d\" width=\"100%%\" height=\"%d\" stroke=\"silver\" stroke-width=\"1\" fill=\"silver\"></rect></svg></a></td></tr></table></td>", this.drawCellValues(stats.getPassed(), stats.getFailed(), stats.getSkipped()), 0, passedRatio, passedRatio, failedRatio, failedRatio + passedRatio, skippedRatio);
            }
            return String.format("<td bgcolor=\"silver\"><center><b>N/A</b></center></td>", new Object[0]);
        }
    }

    private static interface CellDrawer {
        public String drawCell(BreakdownStats var1) throws Exception;
    }
}

